/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android.manavo.rest;

import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class RestRequest {
    private String username;
    private String password;
    private String host;
    private int port = 80;
    private int sslPort = 443;
    private Handler handler;
    private ExecuteAsyncRequest asyncTask;
    private boolean acceptAllSslCertificates = false;
    private DefaultHttpClient httpClient;
    private boolean useSsl = true;
    private List<NameValuePair> data;
    private String userAgent = null;
    private HttpContext requestContext = new BasicHttpContext();
    private String contentType = null;

    public RestRequest() {
        this.httpClient = this.getNewHttpClient();
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public HttpContext getRequestContext() {
        return this.requestContext;
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void authorize(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSslPort(int port) {
        this.sslPort = port;
    }

    public void setSsl(boolean ssl) {
        this.useSsl = ssl;
    }

    public void acceptAllSslCertificates() {
        this.acceptAllSslCertificates = true;
    }

    public void setData(List<NameValuePair> data) {
        this.data = data;
    }

    public void setUserAgent(String agent) {
        this.userAgent = agent;
    }

    public void get(String url) {
        if (this.data.size() > 0) {
            url = url.indexOf("?") == -1 ? url + "?" : url + "&";
            for (int i = 0; i < this.data.size(); ++i) {
                NameValuePair p = this.data.get(i);
                try {
                    url = url + p.getName() + "=" + URLEncoder.encode(p.getValue(), "utf-8") + "&";
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            url = url.substring(0, url.length() - 1);
        }
        HttpGet httpGet = new HttpGet(url);
        this.prepareRequest((HttpRequest)httpGet);
    }

    public void post(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(this.prepareData(this.data));
        this.prepareRequest((HttpRequest)httpPost);
    }

    public void put(String url) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity(this.prepareData(this.data));
        this.prepareRequest((HttpRequest)httpPut);
    }

    public void delete(String url) {
        HttpDelete httpDelete = new HttpDelete(url);
        this.prepareRequest((HttpRequest)httpDelete);
    }

    protected HttpEntity prepareData(List<NameValuePair> nameValuePairs) {
        if (this.contentType != null && this.contentType.equalsIgnoreCase("application/json")) {
            JSONObject data = new JSONObject();
            try {
                for (int i = 0; i < nameValuePairs.size(); ++i) {
                    NameValuePair p = nameValuePairs.get(i);
                    data.put(p.getName(), (Object)p.getValue());
                }
                Log.e((String)"RestRequestSending", (String)data.toString());
                StringEntity se = new StringEntity(data.toString());
                se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
                return se;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void prepareRequest(HttpRequest request) {
        if (this.contentType != null) {
            request.setHeader("Content-type", this.contentType);
        }
        request.setHeader("Accept", "application/json");
        this.asyncTask = new ExecuteAsyncRequest();
        this.asyncTask.execute(new HttpRequest[]{request});
    }

    public void cancelRequest() {
        if (this.asyncTask != null) {
            this.asyncTask.cancel(true);
        }
    }

    private Bundle executeRequest(HttpRequest request) {
        Bundle b = new Bundle();
        try {
            String responseData;
            if (this.userAgent != null) {
                this.httpClient.getParams().setParameter("http.useragent", (Object)this.userAgent);
            }
            if (this.username != null && this.password != null) {
                UsernamePasswordCredentials upc = new UsernamePasswordCredentials(this.username, this.password);
                BasicScheme basicAuth = new BasicScheme();
                request.addHeader(basicAuth.authenticate((Credentials)upc, request));
            }
            request.addHeader("Accept-Encoding", "gzip");
            HttpHost targetHost = !this.useSsl ? new HttpHost(this.host, this.port, "http") : new HttpHost(this.host, this.sslPort, "https");
            HttpResponse response = this.httpClient.execute(targetHost, request, this.requestContext);
            HttpEntity entity = response.getEntity();
            Header contentEncoding = response.getFirstHeader("Content-Encoding");
            if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                String readed;
                InputStream instream = entity.getContent();
                instream = new GZIPInputStream(instream);
                InputStreamReader reader = new InputStreamReader(instream);
                BufferedReader in = new BufferedReader(reader);
                responseData = "";
                while ((readed = in.readLine()) != null) {
                    responseData = responseData + readed;
                }
            } else {
                responseData = EntityUtils.toString((HttpEntity)entity);
            }
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                b.putString("data", responseData);
            } else {
                b.putString("statusCodeError", responseData);
                b.putInt("statusCodeErrorNumber", response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            b.putString("error", e.getMessage());
        }
        return b;
    }

    private DefaultHttpClient getNewHttpClient() {
        if (this.acceptAllSslCertificates) {
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                MySSLSocketFactory sf = new MySSLSocketFactory(trustStore);
                sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                BasicHttpParams params = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
                int timeoutConnection = 15000;
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutConnection);
                int timeoutSocket = 45000;
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutSocket);
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), this.port));
                registry.register(new Scheme("https", (SocketFactory)sf, this.sslPort));
                ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
                return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            }
            catch (Exception e) {
                return new DefaultHttpClient();
            }
        }
        return new DefaultHttpClient();
    }

    private class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext;

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            this.sslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }

    private class ExecuteAsyncRequest
    extends AsyncTask<HttpRequest, Void, Bundle> {
        private ExecuteAsyncRequest() {
        }

        protected Bundle doInBackground(HttpRequest ... requests) {
            int i$ = 0;
            HttpRequest[] arr$ = requests;
            int len$ = arr$.length;
            if (i$ < len$) {
                HttpRequest request = arr$[i$];
                return RestRequest.this.executeRequest(request);
            }
            return null;
        }

        protected void onPostExecute(Bundle b) {
            Message m = new Message();
            m.setData(b);
            m.setTarget(RestRequest.this.handler);
            m.sendToTarget();
        }
    }
}

