/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import io.doorbell.android.DoorbellApi;
import io.doorbell.android.R;
import io.doorbell.android.callbacks.OnFeedbackSentCallback;
import io.doorbell.android.callbacks.OnShowCallback;
import io.doorbell.android.manavo.rest.RestCallback;
import java.lang.reflect.Method;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class Doorbell
extends AlertDialog.Builder {
    private static final String PROPERTY_MODEL = "Model";
    private static final String PROPERTY_ANDROID_VERSION = "Android Version";
    private static final String PROPERTY_WI_FI_ENABLED = "WiFi enabled";
    private static final String PROPERTY_MOBILE_DATA_ENABLED = "Mobile Data enabled";
    private static final String PROPERTY_GPS_ENABLED = "GPS enabled";
    private static final String PROPERTY_SCREEN_RESOLUTION = "Screen Resolution";
    private static final String PROPERTY_ACTIVITY = "Activity";
    private static final String PROPERTY_APP_VERSION_NAME = "App Version Name";
    private static final String PROPERTY_APP_VERSION_CODE = "App Version Code";
    private static final String PROPERTY_APP_LANGUAGE = "App Language";
    private static final String PROPERTY_DEVICE_LANGUAGE = "Device Language";
    private static final String POWERED_BY_DOORBELL_TEXT = "Powered by <a href=\"https://doorbell.io\">Doorbell.io</a>";
    private Activity mActivity;
    private Context mContext;
    private OnFeedbackSentCallback mOnFeedbackSentCallback = null;
    private OnShowCallback mOnShowCallback = null;
    private String mName = "";
    private EditText mMessageField;
    private EditText mEmailField;
    private TextView mPoweredByField;
    private Bitmap mScreenshot;
    private JSONObject mProperties;
    private DoorbellApi mApi;

    public Doorbell(Activity activity, long id, String privateKey) {
        super((Context)activity);
        this.mApi = new DoorbellApi(activity);
        this.mProperties = new JSONObject();
        this.mActivity = activity;
        this.mContext = activity;
        this.setAppId(id);
        this.setApiKey(privateKey);
        this.setTitle(activity.getString(R.string.doorbell_title));
        this.setCancelable(true);
        this.buildProperties();
        PackageManager manager = activity.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(activity.getPackageName(), 0);
            this.addProperty(PROPERTY_APP_VERSION_NAME, info.versionName);
            this.addProperty(PROPERTY_APP_VERSION_CODE, info.versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.buildView();
    }

    private void buildProperties() {
        this.addProperty(PROPERTY_MODEL, Build.MODEL);
        this.addProperty(PROPERTY_ANDROID_VERSION, Build.VERSION.RELEASE);
        try {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            SupplicantState supState = wifiInfo.getSupplicantState();
            this.addProperty(PROPERTY_WI_FI_ENABLED, supState);
        }
        catch (Exception supState) {
            // empty catch block
        }
        boolean mobileDataEnabled = false;
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        try {
            Class<?> cmClass = Class.forName(cm.getClass().getName());
            Method method = cmClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            mobileDataEnabled = (Boolean)method.invoke((Object)cm, new Object[0]);
        }
        catch (Exception cmClass) {
            // empty catch block
        }
        this.addProperty(PROPERTY_MOBILE_DATA_ENABLED, mobileDataEnabled);
        try {
            LocationManager manager = (LocationManager)this.mContext.getSystemService("location");
            boolean gpsEnabled = manager.isProviderEnabled("gps");
            this.addProperty(PROPERTY_GPS_ENABLED, gpsEnabled);
        }
        catch (Exception manager) {
            // empty catch block
        }
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            String resolution = Integer.toString(metrics.widthPixels) + "x" + Integer.toString(metrics.heightPixels);
            this.addProperty(PROPERTY_SCREEN_RESOLUTION, resolution);
        }
        catch (Exception metrics) {
            // empty catch block
        }
        try {
            String activityName = this.mActivity.getClass().getSimpleName();
            this.addProperty(PROPERTY_ACTIVITY, activityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addProperty(PROPERTY_APP_LANGUAGE, this.mActivity.getResources().getConfiguration().locale.getDisplayName());
        this.addProperty(PROPERTY_DEVICE_LANGUAGE, Locale.getDefault().getDisplayName());
    }

    public Doorbell setApiLanguage(String language) {
        this.mApi.setLanguage(language);
        return this;
    }

    public Doorbell addProperty(String key, Object value) {
        try {
            this.mProperties.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Doorbell setAppId(long id) {
        this.mApi.setAppId(id);
        return this;
    }

    public Doorbell setApiKey(String key) {
        this.mApi.setApiKey(key);
        return this;
    }

    public Doorbell setEmailFieldVisibility(int visibility) {
        this.mEmailField.setVisibility(visibility);
        return this;
    }

    public Doorbell setPoweredByVisibility(int visibility) {
        this.mPoweredByField.setVisibility(visibility);
        return this;
    }

    public Doorbell setEmailHint(String emailHint) {
        this.mEmailField.setHint((CharSequence)emailHint);
        return this;
    }

    public Doorbell setEmailHint(int emailHintResId) {
        this.mEmailField.setHint(emailHintResId);
        return this;
    }

    public Doorbell setMessageHint(String messageHint) {
        this.mMessageField.setHint((CharSequence)messageHint);
        return this;
    }

    public Doorbell setMessageHint(int messageHintResId) {
        this.mMessageField.setHint(messageHintResId);
        return this;
    }

    public Doorbell setPositiveButtonText(String text) {
        this.setPositiveButton(text, null);
        return this;
    }

    public Doorbell setPositiveButtonText(int textResId) {
        this.setPositiveButton(textResId, null);
        return this;
    }

    public Doorbell setNegativeButtonText(String text) {
        this.setNegativeButton(text, null);
        return this;
    }

    public Doorbell setNegativeButtonText(int textResId) {
        this.setNegativeButton(textResId, null);
        return this;
    }

    public Doorbell setTitle(String title) {
        super.setTitle((CharSequence)title);
        return this;
    }

    public Doorbell setTitle(int titleResId) {
        super.setTitle(titleResId);
        return this;
    }

    public Doorbell setEmail(String email) {
        this.mEmailField.setText((CharSequence)email);
        return this;
    }

    public Doorbell setOnShowCallback(OnShowCallback onShowCallback) {
        this.mOnShowCallback = onShowCallback;
        return this;
    }

    public Doorbell setOnFeedbackSentCallback(OnFeedbackSentCallback onFeedbackSentCallback) {
        this.mOnFeedbackSentCallback = onFeedbackSentCallback;
        return this;
    }

    public Doorbell setName(String name) {
        this.mName = name;
        return this;
    }

    public Doorbell impression() {
        this.mApi.impression();
        return this;
    }

    public Doorbell captureScreenshot() {
        View v = this.mActivity.getWindow().getDecorView().getRootView();
        v.setDrawingCacheEnabled(true);
        this.mScreenshot = Bitmap.createBitmap((Bitmap)v.getDrawingCache());
        v.setDrawingCacheEnabled(false);
        return this;
    }

    private void buildView() {
        LinearLayout mainLayout = new LinearLayout(this.mContext);
        mainLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int padding = (int)this.mContext.getResources().getDimension(R.dimen.form_side_padding);
        mainLayout.setPadding(padding, 0, padding, 0);
        mainLayout.setOrientation(1);
        this.mMessageField = new EditText(this.mContext);
        this.mMessageField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mMessageField.setMinLines(2);
        this.mMessageField.setGravity(48);
        this.mMessageField.setInputType(this.mMessageField.getInputType() | 0x4000);
        this.setMessageHint(this.mActivity.getString(R.string.doorbell_message_hint));
        mainLayout.addView((View)this.mMessageField);
        this.mEmailField = new EditText(this.mContext);
        this.mEmailField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mEmailField.setInputType(33);
        this.setEmailHint(this.mActivity.getString(R.string.doorbell_email_hint));
        mainLayout.addView((View)this.mEmailField);
        this.mPoweredByField = new TextView(this.mContext);
        this.mPoweredByField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mPoweredByField.setText((CharSequence)Html.fromHtml((String)POWERED_BY_DOORBELL_TEXT));
        this.mPoweredByField.setPadding(7, 7, 7, 7);
        this.mPoweredByField.setMovementMethod(LinkMovementMethod.getInstance());
        mainLayout.addView((View)this.mPoweredByField);
        this.setView((View)mainLayout);
        this.setPositiveButtonText(this.mActivity.getString(R.string.doorbell_send));
        this.setNegativeButtonText(this.mActivity.getString(R.string.doorbell_cancel));
    }

    public AlertDialog show() {
        this.mApi.open();
        final AlertDialog dialog = super.show();
        Button positiveButton = dialog.getButton(-1);
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Doorbell.this.mApi.setLoadingMessage(Doorbell.this.mActivity.getString(R.string.doorbell_sending));
                Doorbell.this.mApi.setCallback(new RestCallback(){

                    @Override
                    public void success(Object obj) {
                        if (Doorbell.this.mOnFeedbackSentCallback != null) {
                            Doorbell.this.mOnFeedbackSentCallback.handle(obj.toString());
                        } else {
                            Toast.makeText((Context)Doorbell.this.mContext, (CharSequence)obj.toString(), (int)1).show();
                        }
                        Doorbell.this.mMessageField.setText((CharSequence)"");
                        Doorbell.this.mProperties = new JSONObject();
                        dialog.hide();
                    }
                });
                if (Doorbell.this.mScreenshot != null) {
                    Doorbell.this.mApi.sendFeedbackWithScreenshot(Doorbell.this.mMessageField.getText().toString(), Doorbell.this.mEmailField.getText().toString(), Doorbell.this.mProperties, Doorbell.this.mName, Doorbell.this.mScreenshot);
                } else {
                    Doorbell.this.mApi.sendFeedback(Doorbell.this.mMessageField.getText().toString(), Doorbell.this.mEmailField.getText().toString(), Doorbell.this.mProperties, Doorbell.this.mName);
                }
            }
        });
        if (this.mOnShowCallback != null) {
            this.mOnShowCallback.handle();
        }
        return dialog;
    }
}

