/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android.manavo.rest;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.MatrixCursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;
import io.doorbell.android.manavo.rest.RestCache;
import io.doorbell.android.manavo.rest.RestCallback;
import io.doorbell.android.manavo.rest.RestErrorCallback;
import io.doorbell.android.manavo.rest.RestRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestApi {
    protected Activity activity;
    protected RestRequest rest;
    protected RestCallback callback;
    protected RestErrorCallback errorCallback;
    protected String BASE_URL;
    protected String urlSuffix = "";
    protected String loadingMessage;
    protected ProgressDialog progressDialog;
    private List<NameValuePair> parameters;
    protected int cachePolicy = 0;
    public String endpoint = null;
    private String requestType = null;

    public RestApi(Activity activity) {
        this.activity = activity;
        this.reset();
        this.rest = new RestRequest();
        this.rest.setHandler(new Handler(){

            public void handleMessage(Message msg) {
                Bundle b = msg.getData();
                if (b.containsKey("data")) {
                    String data = b.getString("data");
                    try {
                        if (data == null) {
                            RestApi.this.onSuccess(null);
                        } else if (data.trim().substring(0, 1).equalsIgnoreCase("{")) {
                            JSONObject returnObject = new JSONObject(data);
                            if (RestApi.this.requestType.equalsIgnoreCase("get") && RestApi.this.cachePolicy != 0) {
                                RestCache.save(RestApi.this, data.trim());
                            }
                            if (RestApi.this.cachePolicy != 4) {
                                RestApi.this.onSuccess(returnObject);
                            }
                        } else if (data.trim().substring(0, 1).equalsIgnoreCase("[")) {
                            JSONArray returnObject = new JSONArray(data);
                            if (RestApi.this.requestType.equalsIgnoreCase("get") && RestApi.this.cachePolicy != 0) {
                                RestCache.save(RestApi.this, data.trim());
                            }
                            if (RestApi.this.cachePolicy != 4) {
                                RestApi.this.onSuccess(returnObject);
                            }
                        } else {
                            Log.d((String)"RestApi", (String)data);
                            if (RestApi.this.requestType.equalsIgnoreCase("get") && RestApi.this.cachePolicy != 0) {
                                RestCache.save(RestApi.this, data.trim());
                            }
                            if (RestApi.this.cachePolicy != 4) {
                                RestApi.this.onSuccess(data);
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        RestApi.this.onError(e.getMessage());
                    }
                } else if (b.containsKey("error")) {
                    RestApi.this.onError(b.getString("error"));
                } else if (b.containsKey("statusCodeError") && b.containsKey("statusCodeErrorNumber")) {
                    RestApi.this.onStatusCodeError(b.getInt("statusCodeErrorNumber"), b.getString("statusCodeError"));
                } else {
                    RestApi.this.onError("Misconfigured code");
                }
                RestApi.this.reset();
                RestApi.this.hideLoadingDialog();
            }
        });
    }

    public void setCachePolicy(int cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public void reset() {
        this.loadingMessage = "Loading...";
        this.callback = null;
        this.errorCallback = null;
        this.endpoint = null;
        this.cachePolicy = 0;
        this.parameters = new ArrayList<NameValuePair>();
    }

    public void addParameter(String name, Object value) {
        this.parameters.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
    }

    public void setLoadingMessage(String message) {
        this.loadingMessage = message;
    }

    public void setLoadingMessage(int messageId) {
        this.loadingMessage = this.activity.getResources().getString(messageId);
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public void showLoadingDialog() {
        if (this.loadingMessage != null) {
            this.progressDialog = new ProgressDialog((Context)this.activity);
            this.progressDialog.setMessage((CharSequence)this.loadingMessage);
            this.progressDialog.setCancelable(true);
            this.progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    RestApi.this.cancelRequest();
                    if (RestApi.this.requestType != null && RestApi.this.requestType.equalsIgnoreCase("get")) {
                        RestApi.this.activity.finish();
                    }
                }
            });
            this.progressDialog.show();
        }
    }

    public void cancelRequest() {
        this.rest.cancelRequest();
        this.hideLoadingDialog();
    }

    public void hideLoadingDialog() {
        this.setProgressBarIndeterminateVisibility(false);
        if (this.loadingMessage != null && this.progressDialog != null && this.progressDialog.isShowing()) {
            try {
                this.progressDialog.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void setProgressBarIndeterminateVisibility(boolean visible) {
        this.activity.setProgressBarIndeterminateVisibility(false);
    }

    public void removeProgressDialog() {
        this.setProgressBarIndeterminateVisibility(false);
        if (this.loadingMessage != null && this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
        }
    }

    public void setUserAgent(String agent) {
        this.rest.setUserAgent(agent);
    }

    public void acceptAllSslCertificates() {
        this.rest.acceptAllSslCertificates();
    }

    public RestApi setCallback(RestCallback callback) {
        this.callback = callback;
        return this;
    }

    public RestApi setErrorCallback(RestErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public void onSuccess(Object obj) {
        if (this.callback != null) {
            this.callback.success(obj);
        }
    }

    public void onStatusCodeError(int code, String data) {
        if (this.errorCallback != null) {
            this.errorCallback.error(data);
        } else {
            Toast.makeText((Context)this.activity, (CharSequence)data, (int)1).show();
        }
    }

    public void onError(String message) {
        if (this.errorCallback != null) {
            this.errorCallback.error(message);
        } else {
            Toast.makeText((Context)this.activity, (CharSequence)message, (int)1).show();
        }
    }

    protected void get(String url) {
        boolean gotCache = false;
        this.requestType = "get";
        this.endpoint = this.getEndpoint(url);
        if ((this.cachePolicy == 1 || this.cachePolicy == 3) && RestCache.exists(this)) {
            String data = RestCache.get(this);
            try {
                if (data.trim().substring(0, 1).equalsIgnoreCase("{")) {
                    JSONObject returnObject = new JSONObject(data);
                    gotCache = true;
                    this.onSuccess(returnObject);
                } else if (data.trim().substring(0, 1).equalsIgnoreCase("[")) {
                    JSONArray returnObject = new JSONArray(data);
                    gotCache = true;
                    this.onSuccess(returnObject);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.cachePolicy != 3 || !gotCache) {
            if (!gotCache && this.cachePolicy != 4) {
                this.showLoadingDialog();
            } else {
                this.setProgressBarIndeterminateVisibility(true);
            }
            this.rest.setData(this.parameters);
            this.rest.get(this.endpoint);
        }
    }

    protected void post(String url) {
        this.requestType = "post";
        this.endpoint = this.getEndpoint(url);
        this.showLoadingDialog();
        this.rest.setData(this.parameters);
        this.rest.post(this.endpoint);
    }

    protected void put(String url) {
        this.requestType = "put";
        this.endpoint = this.getEndpoint(url);
        this.showLoadingDialog();
        this.rest.setData(this.parameters);
        this.rest.put(this.endpoint);
    }

    protected void delete(String url) {
        this.requestType = "delete";
        this.endpoint = this.getEndpoint(url);
        this.showLoadingDialog();
        this.rest.delete(this.endpoint);
    }

    public String getEndpoint(String part) {
        return this.BASE_URL + part + this.urlSuffix;
    }

    public MatrixCursor jsonArrayToMatrixCursor(JSONArray data, String[] keys, String keyToBeId) {
        return this.jsonArrayToMatrixCursor(data, keys, keyToBeId, null);
    }

    public JSONObject getObjectFromCursor(JSONArray data, String key, long value) {
        JSONObject returnData = null;
        try {
            for (int i = 0; i < data.length(); ++i) {
                returnData = data.getJSONObject(i);
                if ((long)returnData.getInt(key) != value) continue;
                return returnData;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return returnData;
    }

    public MatrixCursor jsonArrayToMatrixCursor(JSONArray data, String[] keys, String keyToBeId, JSONObject filter) {
        MatrixCursor c = null;
        if (data == null) {
            return c;
        }
        try {
            int i;
            String[] keyAttributes = new String[keys.length];
            System.arraycopy(keys, 0, keyAttributes, 0, keys.length);
            for (i = 0; i < keyAttributes.length; ++i) {
                String key = keyAttributes[i];
                if (!key.equalsIgnoreCase(keyToBeId)) continue;
                keyAttributes[i] = key = "_id";
                break;
            }
            c = filter == null ? new MatrixCursor(keyAttributes, data.length()) : new MatrixCursor(keyAttributes);
            for (int j = 0; j < data.length(); ++j) {
                JSONObject o = data.getJSONObject(j);
                if (!this.checkFilter(o, filter)) continue;
                MatrixCursor.RowBuilder row = c.newRow();
                for (i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    if (o.has(key) && !o.isNull(key)) {
                        row.add(o.get(key));
                        continue;
                    }
                    row.add(null);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return c;
    }

    private boolean checkFilter(JSONObject data, JSONObject filter) throws JSONException {
        if (filter == null) {
            return true;
        }
        boolean ok = true;
        JSONArray names = filter.names();
        if (names != null) {
            block0: for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                if (key.contains(".")) {
                    StringTokenizer tokens = new StringTokenizer(key, ".");
                    JSONObject tempData = new JSONObject(data.toString());
                    String token = null;
                    while (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        if (!tokens.hasMoreTokens()) continue;
                        if (tempData.has(token) && !tempData.isNull(token)) {
                            tempData = tempData.getJSONObject(token);
                            continue;
                        }
                        ok = false;
                        break;
                    }
                    if (token == null || !tempData.has(token) || tempData.get(token).equals(filter.get(key))) continue;
                    ok = false;
                    break;
                }
                if (data.has(key) && data.get(key) instanceof JSONArray) {
                    ok = false;
                    JSONArray array = data.getJSONArray(key);
                    for (int j = 0; j < array.length(); ++j) {
                        if (!array.get(j).equals(filter.get(key))) continue;
                        ok = true;
                        break block0;
                    }
                    break;
                }
                if (data.has(key)) {
                    if (data.get(key).equals(filter.get(key))) continue;
                    ok = false;
                    break;
                }
                ok = false;
                break;
            }
        }
        return ok;
    }

    public static JSONArray replaceObject(JSONArray data, JSONObject obj, String id) {
        JSONArray newData = new JSONArray();
        try {
            for (int i = 0; i < data.length(); ++i) {
                JSONObject o = data.getJSONObject(i);
                if (o.getLong(id) != obj.getLong(id)) {
                    newData.put((Object)o);
                    continue;
                }
                newData.put((Object)obj);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return newData;
    }
}

