/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android.manavo.rest;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class RestRequest {
    private String username;
    private String password;
    private Handler handler;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private boolean acceptAllSslCertificates = false;
    private Map<String, String> data;
    private String userAgent = null;
    private String contentType = null;

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void authorize(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void acceptAllSslCertificates() {
        this.acceptAllSslCertificates = true;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public void setUserAgent(String agent) {
        this.userAgent = agent;
    }

    public void get(String url) throws IOException {
        if (this.data.size() > 0) {
            url = !url.contains("?") ? url + "?" : url + "&";
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String key : this.data.keySet()) {
                try {
                    urlBuilder.append(URLEncoder.encode(key, "utf-8")).append("=").append(URLEncoder.encode(this.data.get(key), "utf-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            url = urlBuilder.toString();
            url = url.substring(0, url.length() - 1);
        }
        HttpsURLConnection httpURLConnection = (HttpsURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.prepareRequest(httpURLConnection);
    }

    public void post(String url) throws IOException {
        HttpsURLConnection httpURLConnection = (HttpsURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        this.prepareRequest(httpURLConnection);
    }

    public void put(String url) throws IOException {
        HttpsURLConnection httpURLConnection = (HttpsURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("PUT");
        httpURLConnection.setDoOutput(true);
        this.prepareRequest(httpURLConnection);
    }

    public void delete(String url) throws IOException {
        HttpsURLConnection httpURLConnection = (HttpsURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("DELETE");
        this.prepareRequest(httpURLConnection);
    }

    protected byte[] prepareData() {
        if (this.contentType != null && this.contentType.equalsIgnoreCase("application/json")) {
            JSONObject data = new JSONObject();
            try {
                for (String key : this.data.keySet()) {
                    data.put(key, (Object)this.data.get(key));
                }
                Log.d((String)"RestRequestSending", (String)data.toString());
                return data.toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            StringBuilder data = new StringBuilder();
            for (String key : this.data.keySet()) {
                data.append(URLEncoder.encode(key, "utf-8")).append("=").append(URLEncoder.encode(this.data.get(key), "utf-8")).append("&");
            }
            if (data.length() > 0) {
                data.substring(0, data.length() - 1);
            }
            return data.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void prepareRequest(HttpsURLConnection request) {
        request.setDoInput(true);
        if (this.contentType != null) {
            request.setRequestProperty("Content-type", this.contentType);
        }
        request.setRequestProperty("Accept", "application/json");
        this.executorService.execute(() -> {
            Bundle b = this.executeRequest(request);
            Message m = new Message();
            m.setData(b);
            m.setTarget(this.handler);
            m.sendToTarget();
        });
    }

    public void cancelRequest() {
        this.executorService.shutdown();
    }

    private Bundle executeRequest(HttpsURLConnection request) {
        Bundle b = new Bundle();
        try {
            StringBuilder responseDataBuilder;
            byte[] input;
            Object authHeaderValue;
            if (this.userAgent != null) {
                request.setRequestProperty("User-Agent", this.userAgent);
            }
            if (this.username != null && this.password != null) {
                String auth = this.username + ":" + this.password;
                byte[] encodedAuth = Base64.encode((byte[])auth.getBytes(StandardCharsets.UTF_8), (int)0);
                authHeaderValue = "Basic " + new String(encodedAuth);
                request.setRequestProperty("Authorization", (String)authHeaderValue);
            }
            request.addRequestProperty("Accept-Encoding", "gzip");
            if ((request.getRequestMethod().equalsIgnoreCase("POST") || request.getRequestMethod().equalsIgnoreCase("PUT")) && (input = this.prepareData()).length > 0) {
                OutputStream os = request.getOutputStream();
                authHeaderValue = null;
                try {
                    os.write(input, 0, input.length);
                }
                catch (Throwable throwable) {
                    authHeaderValue = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (authHeaderValue != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)authHeaderValue).addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            int statusCode = request.getResponseCode();
            InputStream responseInputStream = request.getResponseCode() >= 200 && request.getResponseCode() < 300 ? request.getInputStream() : request.getErrorStream();
            String contentEncoding = request.getHeaderField("Content-Encoding");
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                String line;
                GZIPInputStream gzipInputStream = new GZIPInputStream(responseInputStream);
                InputStreamReader reader = new InputStreamReader(gzipInputStream);
                BufferedReader in = new BufferedReader(reader);
                responseDataBuilder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    responseDataBuilder.append(line);
                }
                in.close();
                reader.close();
                gzipInputStream.close();
            } else {
                String line;
                InputStreamReader reader = new InputStreamReader(responseInputStream);
                BufferedReader in = new BufferedReader(reader);
                responseDataBuilder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    responseDataBuilder.append(line);
                }
                in.close();
                reader.close();
            }
            String responseData = responseDataBuilder.toString();
            Log.d((String)"RestRequest", (String)("ResponseData: " + responseData));
            responseInputStream.close();
            if (statusCode >= 200 && statusCode < 300) {
                b.putString("data", responseData);
            } else {
                b.putString("statusCodeError", responseData);
                b.putInt("statusCodeErrorNumber", statusCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            b.putString("error", e.getMessage());
        }
        return b;
    }
}

