/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android.shake;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.ArrayList;
import java.util.List;

public class ShakeDetector
implements SensorEventListener {
    public static final int SENSITIVITY_LIGHT = 11;
    public static final int SENSITIVITY_MEDIUM = 13;
    public static final int SENSITIVITY_HARD = 15;
    private static final int DEFAULT_ACCELERATION_THRESHOLD = 13;
    private int accelerationThreshold = 13;
    private final SampleQueue queue = new SampleQueue();
    private final Listener listener;
    private SensorManager sensorManager;
    private Sensor accelerometer;

    public ShakeDetector(Listener listener) {
        this.listener = listener;
    }

    public boolean start(SensorManager sensorManager) {
        if (this.accelerometer != null) {
            return true;
        }
        this.accelerometer = sensorManager.getDefaultSensor(1);
        if (this.accelerometer != null) {
            this.sensorManager = sensorManager;
            sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 0);
        }
        return this.accelerometer != null;
    }

    public void stop() {
        if (this.accelerometer != null) {
            this.queue.clear();
            this.sensorManager.unregisterListener((SensorEventListener)this, this.accelerometer);
            this.sensorManager = null;
            this.accelerometer = null;
        }
    }

    public void onSensorChanged(SensorEvent event) {
        boolean accelerating = this.isAccelerating(event);
        long timestamp = event.timestamp;
        this.queue.add(timestamp, accelerating);
        if (this.queue.isShaking()) {
            this.queue.clear();
            this.listener.hearShake();
        }
    }

    private boolean isAccelerating(SensorEvent event) {
        float ax = event.values[0];
        float ay = event.values[1];
        float az = event.values[2];
        double magnitudeSquared = ax * ax + ay * ay + az * az;
        return magnitudeSquared > (double)(this.accelerationThreshold * this.accelerationThreshold);
    }

    public void setSensitivity(int accelerationThreshold) {
        this.accelerationThreshold = accelerationThreshold;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    static class SamplePool {
        private Sample head;

        SamplePool() {
        }

        Sample acquire() {
            Sample acquired = this.head;
            if (acquired == null) {
                acquired = new Sample();
            } else {
                this.head = acquired.next;
            }
            return acquired;
        }

        void release(Sample sample) {
            sample.next = this.head;
            this.head = sample;
        }
    }

    static class Sample {
        long timestamp;
        boolean accelerating;
        Sample next;

        Sample() {
        }
    }

    static class SampleQueue {
        private static final long MAX_WINDOW_SIZE = 500000000L;
        private static final long MIN_WINDOW_SIZE = 250000000L;
        private static final int MIN_QUEUE_SIZE = 4;
        private final SamplePool pool = new SamplePool();
        private Sample oldest;
        private Sample newest;
        private int sampleCount;
        private int acceleratingCount;

        SampleQueue() {
        }

        void add(long timestamp, boolean accelerating) {
            this.purge(timestamp - 500000000L);
            Sample added = this.pool.acquire();
            added.timestamp = timestamp;
            added.accelerating = accelerating;
            added.next = null;
            if (this.newest != null) {
                this.newest.next = added;
            }
            this.newest = added;
            if (this.oldest == null) {
                this.oldest = added;
            }
            ++this.sampleCount;
            if (accelerating) {
                ++this.acceleratingCount;
            }
        }

        void clear() {
            while (this.oldest != null) {
                Sample removed = this.oldest;
                this.oldest = removed.next;
                this.pool.release(removed);
            }
            this.newest = null;
            this.sampleCount = 0;
            this.acceleratingCount = 0;
        }

        void purge(long cutoff) {
            while (this.sampleCount >= 4 && this.oldest != null && cutoff - this.oldest.timestamp > 0L) {
                Sample removed = this.oldest;
                if (removed.accelerating) {
                    --this.acceleratingCount;
                }
                --this.sampleCount;
                this.oldest = removed.next;
                if (this.oldest == null) {
                    this.newest = null;
                }
                this.pool.release(removed);
            }
        }

        List<Sample> asList() {
            ArrayList<Sample> list = new ArrayList<Sample>();
            Sample s = this.oldest;
            while (s != null) {
                list.add(s);
                s = s.next;
            }
            return list;
        }

        boolean isShaking() {
            return this.newest != null && this.oldest != null && this.newest.timestamp - this.oldest.timestamp >= 250000000L && this.acceleratingCount >= (this.sampleCount >> 1) + (this.sampleCount >> 2);
        }
    }

    public static interface Listener {
        public void hearShake();
    }
}

