/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import io.doorbell.android.DoorbellApi;
import io.doorbell.android.R;
import io.doorbell.android.callbacks.OnErrorCallback;
import io.doorbell.android.callbacks.OnFeedbackSentCallback;
import io.doorbell.android.callbacks.OnShowCallback;
import io.doorbell.android.manavo.rest.RestCallback;
import io.doorbell.android.shake.ShakeDetector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class Doorbell {
    private static final String PROPERTY_MODEL = "Model";
    private static final String PROPERTY_ANDROID_VERSION = "Android Version";
    private static final String PROPERTY_WI_FI_ENABLED = "WiFi enabled";
    private static final String PROPERTY_MOBILE_DATA_ENABLED = "Mobile Data enabled";
    private static final String PROPERTY_GPS_ENABLED = "GPS enabled";
    private static final String PROPERTY_SCREEN_RESOLUTION = "Screen Resolution";
    private static final String PROPERTY_ACTIVITY = "Activity";
    private static final String PROPERTY_APP_VERSION_NAME = "App Version Name";
    private static final String PROPERTY_APP_VERSION_CODE = "App Version Code";
    private static final String PROPERTY_APP_LANGUAGE = "App Language";
    private static final String PROPERTY_DEVICE_LANGUAGE = "Device Language";
    private static final String POWERED_BY_DOORBELL_TEXT = "Powered by <a href=\"https://doorbell.io\">Doorbell.io</a>";
    private final Activity mActivity;
    private final Context mContext;
    private final AlertDialog.Builder mDialogBuilder;
    private AlertDialog mDialog;
    private OnFeedbackSentCallback mOnFeedbackSentCallback = null;
    private OnShowCallback mOnShowCallback = null;
    private String mName = "";
    private EditText mMessageField;
    private EditText mEmailField;
    private TextView mNPSLabel;
    private TextView mNPSScoreLabelLow;
    private TextView mNPSScoreLabelHigh;
    private SeekBar mNPSField;
    private LinearLayout mNPSScores;
    private TextView mPoweredByField;
    private Bitmap mScreenshot;
    private Boolean mNPSSelected;
    private int mSeekbarDefaultOffset;
    private JSONObject mProperties;
    private final DoorbellApi mApi;
    private final ShakeDetector shakeDetector;

    public Doorbell(Activity activity, long id, String privateKey) {
        this(activity, id, privateKey, new AlertDialog.Builder((Context)activity));
    }

    public Doorbell(Activity activity, long id, String privateKey, AlertDialog.Builder dialogBuilder) {
        this.mDialogBuilder = dialogBuilder;
        this.mApi = new DoorbellApi(activity);
        this.mProperties = new JSONObject();
        this.mActivity = activity;
        this.mContext = activity;
        this.setAppId(id);
        this.setApiKey(privateKey);
        this.mDialogBuilder.setTitle((CharSequence)activity.getString(R.string.doorbell_title));
        this.mDialogBuilder.setCancelable(true);
        this.buildProperties();
        PackageManager manager = activity.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(activity.getPackageName(), 0);
            this.addProperty(PROPERTY_APP_VERSION_NAME, info.versionName);
            this.addProperty(PROPERTY_APP_VERSION_CODE, info.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.buildView();
        this.shakeDetector = new ShakeDetector(new ShakeDetector.Listener(){

            @Override
            public void hearShake() {
                try {
                    Doorbell.this.show();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void patchTLSOrPromptUser() {
        this.mApi.patchTLSOrPromptUser();
    }

    public boolean isFullySupported() {
        return this.mApi.isFullySupported();
    }

    public AlertDialog.Builder getDialogBuilder() {
        return this.mDialogBuilder;
    }

    private void buildProperties() {
        this.addProperty(PROPERTY_MODEL, Build.MODEL);
        this.addProperty(PROPERTY_ANDROID_VERSION, Build.VERSION.RELEASE);
        try {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            SupplicantState supState = wifiInfo.getSupplicantState();
            this.addProperty(PROPERTY_WI_FI_ENABLED, supState);
        }
        catch (Exception supState) {
            // empty catch block
        }
        boolean mobileDataEnabled = false;
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        try {
            Class<?> cmClass = Class.forName(cm.getClass().getName());
            Method method = cmClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            mobileDataEnabled = (Boolean)method.invoke((Object)cm, new Object[0]);
        }
        catch (Exception cmClass) {
            // empty catch block
        }
        this.addProperty(PROPERTY_MOBILE_DATA_ENABLED, mobileDataEnabled);
        try {
            LocationManager manager = (LocationManager)this.mContext.getSystemService("location");
            boolean gpsEnabled = manager.isProviderEnabled("gps");
            this.addProperty(PROPERTY_GPS_ENABLED, gpsEnabled);
        }
        catch (Exception manager) {
            // empty catch block
        }
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            String resolution = Integer.toString(metrics.widthPixels) + "x" + Integer.toString(metrics.heightPixels);
            this.addProperty(PROPERTY_SCREEN_RESOLUTION, resolution);
        }
        catch (Exception metrics) {
            // empty catch block
        }
        try {
            String activityName = this.mActivity.getClass().getSimpleName();
            this.addProperty(PROPERTY_ACTIVITY, activityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addProperty(PROPERTY_APP_LANGUAGE, this.mActivity.getResources().getConfiguration().locale.getDisplayName());
        this.addProperty(PROPERTY_DEVICE_LANGUAGE, Locale.getDefault().getDisplayName());
    }

    public Doorbell setApiLanguage(String language) {
        this.mApi.setLanguage(language);
        return this;
    }

    public Doorbell addProperty(String key, Object value) {
        try {
            this.mProperties.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Doorbell setTags(ArrayList<String> tags) {
        this.mApi.setTags(tags);
        return this;
    }

    public Doorbell setAppId(long id) {
        this.mApi.setAppId(id);
        return this;
    }

    public Doorbell setApiKey(String key) {
        this.mApi.setApiKey(key);
        return this;
    }

    public EditText getMessageField() {
        return this.mMessageField;
    }

    public EditText getEmailField() {
        return this.mEmailField;
    }

    public TextView getNPSLabel() {
        return this.mNPSLabel;
    }

    public SeekBar getNPSField() {
        return this.mNPSField;
    }

    public TextView getNPSScoreLabelLow() {
        return this.mNPSScoreLabelLow;
    }

    public TextView getNPSScoreLabelHigh() {
        return this.mNPSScoreLabelHigh;
    }

    public TextView getPoweredByField() {
        return this.mPoweredByField;
    }

    public Doorbell setPositiveButtonText(String text) {
        this.mDialogBuilder.setPositiveButton((CharSequence)text, null);
        return this;
    }

    public Doorbell setPositiveButtonText(int textResId) {
        this.mDialogBuilder.setPositiveButton(textResId, null);
        return this;
    }

    public Doorbell setNegativeButtonText(String text) {
        this.mDialogBuilder.setNegativeButton((CharSequence)text, null);
        return this;
    }

    public Doorbell setNegativeButtonText(int textResId) {
        this.mDialogBuilder.setNegativeButton(textResId, null);
        return this;
    }

    public Doorbell setEmail(String email) {
        this.mEmailField.setText((CharSequence)email);
        return this;
    }

    public Doorbell setOnShowCallback(OnShowCallback onShowCallback) {
        this.mOnShowCallback = onShowCallback;
        return this;
    }

    public Doorbell setOnErrorCallback(OnErrorCallback onErrorCallback) {
        this.mApi.setOnErrorCallback(onErrorCallback);
        return this;
    }

    public Doorbell setOnFeedbackSentCallback(OnFeedbackSentCallback onFeedbackSentCallback) {
        this.mOnFeedbackSentCallback = onFeedbackSentCallback;
        return this;
    }

    public Doorbell setName(String name) {
        this.mName = name;
        return this;
    }

    public Doorbell impression() {
        this.mApi.impression();
        return this;
    }

    public Doorbell track(String userID, String eventName, JSONObject attributes) {
        DoorbellApi newApi = new DoorbellApi(this.mActivity);
        newApi.setAppId(this.mApi.getAppId());
        newApi.setApiKey(this.mApi.getApiKey());
        newApi.setCallback(new RestCallback(){

            @Override
            public void success(Object obj) {
                try {
                    String action;
                    JSONObject response = (JSONObject)obj;
                    if (response.has("action") && !response.optString("action").equalsIgnoreCase("") && (action = response.getString("action")).equalsIgnoreCase("show")) {
                        Doorbell.this.show(response.getInt("event_id"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        newApi.track(userID, eventName, attributes);
        return this;
    }

    public Doorbell captureScreenshot() {
        try {
            View v = this.mActivity.getWindow().getDecorView().getRootView();
            v.setDrawingCacheEnabled(true);
            Bitmap drawingCache = v.getDrawingCache();
            if (drawingCache != null) {
                this.mScreenshot = Bitmap.createBitmap((Bitmap)drawingCache);
            } else {
                Log.e((String)"Doorbell", (String)"Drawing cache was null");
            }
            v.setDrawingCacheEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private void buildView() {
        LinearLayout mainLayout = new LinearLayout(this.mContext);
        mainLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int padding = (int)this.mContext.getResources().getDimension(R.dimen.form_side_padding);
        mainLayout.setPadding(padding, 0, padding, 0);
        mainLayout.setOrientation(1);
        this.mMessageField = new EditText(this.mContext);
        this.mMessageField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mMessageField.setMinLines(2);
        this.mMessageField.setGravity(48);
        this.mMessageField.setInputType(this.mMessageField.getInputType() | 0x4000);
        this.mMessageField.setHint((CharSequence)this.mActivity.getString(R.string.doorbell_message_hint));
        mainLayout.addView((View)this.mMessageField);
        this.mEmailField = new EditText(this.mContext);
        this.mEmailField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mEmailField.setInputType(33);
        this.mEmailField.setHint((CharSequence)this.mActivity.getString(R.string.doorbell_email_hint));
        mainLayout.addView((View)this.mEmailField);
        this.mNPSLabel = new TextView(this.mContext);
        LinearLayout.LayoutParams npsLabelLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        npsLabelLayoutParams.setMargins(0, 10, 0, 0);
        this.mNPSLabel.setLayoutParams((ViewGroup.LayoutParams)npsLabelLayoutParams);
        this.mNPSLabel.setText(R.string.doorbell_nps_label);
        this.mNPSLabel.setVisibility(8);
        mainLayout.addView((View)this.mNPSLabel);
        this.mNPSField = Build.VERSION.SDK_INT >= 24 ? new SeekBar(this.mContext, null, 0, 16974553) : new SeekBar(this.mContext);
        this.mNPSField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mNPSField.setMax(10);
        this.mSeekbarDefaultOffset = this.mNPSField.getThumbOffset();
        this.resetNPS();
        this.mNPSField.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                Doorbell.this.mNPSField.setThumbOffset(Doorbell.this.mSeekbarDefaultOffset);
                Doorbell.this.mNPSSelected = true;
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        mainLayout.addView((View)this.mNPSField);
        this.mNPSField.setVisibility(8);
        this.mNPSScores = new LinearLayout(this.mContext);
        LinearLayout.LayoutParams npsScoresLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        npsScoresLayoutParams.setMargins(0, 0, 0, 10);
        this.mNPSScores.setLayoutParams((ViewGroup.LayoutParams)npsScoresLayoutParams);
        this.mNPSScores.setOrientation(0);
        this.mNPSScores.setVisibility(8);
        this.mNPSScoreLabelLow = new TextView(this.mContext);
        this.mNPSScoreLabelLow.setText(R.string.doorbell_nps_score_low);
        this.mNPSScoreLabelLow.setGravity(0x800003);
        this.mNPSScoreLabelLow.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        this.mNPSScores.addView((View)this.mNPSScoreLabelLow);
        this.mNPSScoreLabelHigh = new TextView(this.mContext);
        this.mNPSScoreLabelHigh.setText(R.string.doorbell_nps_score_high);
        this.mNPSScoreLabelHigh.setGravity(0x800005);
        this.mNPSScoreLabelHigh.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        this.mNPSScores.addView((View)this.mNPSScoreLabelHigh);
        mainLayout.addView((View)this.mNPSScores);
        this.mPoweredByField = new TextView(this.mContext);
        this.mPoweredByField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mPoweredByField.setText((CharSequence)Html.fromHtml((String)POWERED_BY_DOORBELL_TEXT));
        this.mPoweredByField.setPadding(7, 7, 7, 7);
        this.mPoweredByField.setMovementMethod(LinkMovementMethod.getInstance());
        mainLayout.addView((View)this.mPoweredByField);
        this.mDialogBuilder.setView((View)mainLayout);
        this.setPositiveButtonText(this.mActivity.getString(R.string.doorbell_send));
        this.setNegativeButtonText(this.mActivity.getString(R.string.doorbell_cancel));
    }

    private void resetNPS() {
        this.mNPSField.setThumbOffset(100000);
        this.mNPSField.setProgress(0);
        this.mNPSSelected = false;
    }

    public Doorbell enableNPSRatings() {
        this.mNPSLabel.setVisibility(0);
        this.mNPSField.setVisibility(0);
        this.mNPSScores.setVisibility(0);
        return this;
    }

    public Doorbell disableNPSRatings() {
        this.mNPSLabel.setVisibility(8);
        this.mNPSField.setVisibility(8);
        this.mNPSScores.setVisibility(8);
        this.resetNPS();
        return this;
    }

    public Doorbell enableShowOnShake() {
        SensorManager sensorManager = (SensorManager)this.mActivity.getSystemService("sensor");
        this.shakeDetector.start(sensorManager);
        return this;
    }

    public Doorbell disableShowOnShake() {
        this.shakeDetector.stop();
        SensorManager sensorManager = (SensorManager)this.mActivity.getSystemService("sensor");
        sensorManager.unregisterListener((SensorEventListener)this.shakeDetector);
        return this;
    }

    public Doorbell setShakeSensitivity(int sensitivity) {
        this.shakeDetector.setSensitivity(sensitivity);
        return this;
    }

    public Doorbell destroy() {
        this.disableShowOnShake();
        return this;
    }

    public Doorbell resetProperties() {
        this.mProperties = new JSONObject();
        this.buildProperties();
        return this;
    }

    public AlertDialog show() {
        return this.show(0);
    }

    public AlertDialog show(int eventID) {
        DoorbellApi newApi = new DoorbellApi(this.mActivity);
        newApi.setAppId(this.mApi.getAppId());
        newApi.setApiKey(this.mApi.getApiKey());
        newApi.open();
        this.mApi.setEventID(eventID);
        if (this.mDialog == null) {
            this.mDialog = this.mDialogBuilder.create();
            this.mDialog.setOnDismissListener(dialogInterface -> this.mApi.setEventID(0));
        }
        this.mDialog.show();
        Button positiveButton = this.mDialog.getButton(-1);
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Doorbell.this.mApi.setLoadingMessage(Doorbell.this.mActivity.getString(R.string.doorbell_sending));
                Doorbell.this.mApi.setCallback(new RestCallback(){

                    @Override
                    public void success(Object obj) {
                        try {
                            if (Doorbell.this.mOnFeedbackSentCallback != null) {
                                Doorbell.this.mOnFeedbackSentCallback.handle(obj.toString());
                            } else {
                                Toast.makeText((Context)Doorbell.this.mContext, (CharSequence)obj.toString(), (int)1).show();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Doorbell.this.mMessageField.setText((CharSequence)"");
                        Doorbell.this.resetNPS();
                        Doorbell.this.mDialog.hide();
                    }
                });
                if (Doorbell.this.mNPSSelected.booleanValue()) {
                    Doorbell.this.mApi.setNPSRating(Doorbell.this.mNPSField.getProgress());
                } else {
                    Doorbell.this.mApi.setNPSRating(-1);
                }
                if (Doorbell.this.mScreenshot != null) {
                    Doorbell.this.mApi.sendFeedbackWithScreenshot(Doorbell.this.mMessageField.getText().toString(), Doorbell.this.mEmailField.getText().toString(), Doorbell.this.mProperties, Doorbell.this.mName, Doorbell.this.mScreenshot);
                } else {
                    Doorbell.this.mApi.sendFeedback(Doorbell.this.mMessageField.getText().toString(), Doorbell.this.mEmailField.getText().toString(), Doorbell.this.mProperties, Doorbell.this.mName);
                }
            }
        });
        if (this.mOnShowCallback != null) {
            this.mOnShowCallback.handle();
        }
        return this.mDialog;
    }
}

