/*
 * Decompiled with CFR 0.152.
 */
package io.doov.tsparser.util;

import io.doov.tsparser.TypeScriptParser;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.ParserRuleContext;

public class TsDebugHelper {
    public static void printTokens(Lexer lexer) {
        System.out.println(lexer.getAllTokens().stream().map(o -> "(" + lexer.getRuleNames()[o.getType()] + ": \"" + o.getText() + "\")").collect(Collectors.toList()));
    }

    public static void printTsTree(ParserRuleContext ctx) {
        if (ctx == null) {
            System.out.println("null");
            return;
        }
        String stringTree = ctx.toStringTree(Arrays.asList(TypeScriptParser.ruleNames));
        StringBuilder sb = new StringBuilder();
        int level = 0;
        for (char c : stringTree.toCharArray()) {
            int i;
            if (c == ')') {
                sb.append('\n');
                --level;
                for (i = 0; i < level; ++i) {
                    sb.append('\t');
                }
            }
            sb.append(c);
            if (c != '(') continue;
            sb.append('\n');
            ++level;
            for (i = 0; i < level; ++i) {
                sb.append('\t');
            }
        }
        System.out.println(sb.toString());
    }
}

