/*
 * Decompiled with CFR 0.152.
 */
package io.dronefleet.mavlink.protocol;

class ByteArray {
    private final byte[] bytes;

    ByteArray(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getInt8(int offset) {
        return (int)this.getLong(offset, 1);
    }

    public void putInt8(int value, int offset) {
        this.putLong(value, offset, 1);
    }

    public int getInt16(int offset) {
        return (int)this.getLong(offset, 2);
    }

    public void putInt16(int value, int offset) {
        this.putLong(value, offset, 2);
    }

    public int getInt24(int offset) {
        return (int)this.getLong(offset, 3);
    }

    public void putInt24(int value, int offset) {
        this.putLong(value, offset, 3);
    }

    public long getInt48(int offset) {
        return this.getLong(offset, 6);
    }

    public void putInt48(long value, int offset) {
        this.putLong(value, offset, 6);
    }

    public byte[] slice(int offset, int size) {
        byte[] value = new byte[size];
        System.arraycopy(this.bytes, offset, value, 0, size);
        return value;
    }

    public long getLong(int offset, int size) {
        long value = 0L;
        for (int i = 0; i < size; ++i) {
            value |= ((long)this.bytes[offset + i] & 0xFFL) << i * 8;
        }
        return value;
    }

    public void putLong(long value, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            this.bytes[offset + i] = (byte)(value >> i * 8 & 0xFFL);
        }
    }

    public byte[] array() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }
}

