/*
 * Decompiled with CFR 0.152.
 */
package io.dronefleet.mavlink.protocol;

import io.dronefleet.mavlink.protocol.TransactionalInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MavlinkFrameReader {
    private final TransactionalInputStream in;

    public MavlinkFrameReader(InputStream in) {
        this.in = new TransactionalInputStream(in, 280);
    }

    public boolean next() throws IOException {
        int versionMarker;
        this.in.commit();
        while ((versionMarker = this.in.read()) != -1) {
            int payloadLength = this.in.read();
            if (payloadLength == -1) {
                return false;
            }
            switch (versionMarker) {
                case 254: {
                    return this.in.advance(6 + payloadLength);
                }
                case 253: {
                    int incompatibleFlags = this.in.read();
                    return incompatibleFlags != -1 && this.in.advance(9 + payloadLength + (incompatibleFlags & 1) * 13);
                }
            }
            this.drop();
        }
        return false;
    }

    public byte[] frame() {
        return this.in.getBuffer();
    }

    public void drop() throws IOException {
        this.in.rollback();
        this.in.skip(1L);
        this.in.commit();
    }
}

