/*
 * Decompiled with CFR 0.152.
 */
package io.dronefleet.mavlink.protocol;

import io.dronefleet.mavlink.protocol.MavlinkFrameReader;
import io.dronefleet.mavlink.protocol.MavlinkPacket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class MavlinkPacketReader {
    private final MavlinkFrameReader in;

    public MavlinkPacketReader(InputStream in) {
        this.in = new MavlinkFrameReader(in);
    }

    public MavlinkPacket next() throws IOException {
        while (this.in.next()) {
            byte[] frame = this.in.frame();
            switch (frame[0] & 0xFF) {
                case 254: {
                    return MavlinkPacket.fromV1Bytes(frame);
                }
                case 253: {
                    return MavlinkPacket.fromV2Bytes(frame);
                }
            }
            this.in.drop();
        }
        throw new EOFException("End of stream");
    }

    public void drop() throws IOException {
        this.in.drop();
    }
}

