/*
 * Decompiled with CFR 0.152.
 */
package io.dronefleet.mavlink.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class TransactionalInputStream
extends PushbackInputStream {
    private final byte[] buffer;
    private int cbuffer;

    TransactionalInputStream(InputStream in, int bufferSize) {
        super(in, bufferSize);
        this.buffer = new byte[bufferSize];
        this.cbuffer = 0;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            this.buffer[this.cbuffer++] = (byte)c;
        }
        return c;
    }

    void rollback() throws IOException {
        super.unread(this.buffer, 0, this.cbuffer);
    }

    boolean advance(int bytes) throws IOException {
        for (int i = 0; i < bytes; ++i) {
            if (this.read() != -1) continue;
            return false;
        }
        return true;
    }

    void commit() {
        this.cbuffer = 0;
    }

    public byte[] getBuffer() {
        byte[] bytes = new byte[this.cbuffer];
        System.arraycopy(this.buffer, 0, bytes, 0, this.cbuffer);
        return bytes;
    }

    @Override
    public void unread(int b) throws IOException {
        this.disallowUnread();
    }

    @Override
    public void unread(byte[] b) throws IOException {
        this.disallowUnread();
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        this.disallowUnread();
    }

    private void disallowUnread() {
        throw new IllegalStateException("use either commit or rollback instead.");
    }
}

