/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.assets;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.bundles.assets.AssetServlet;
import io.dropwizard.bundles.assets.AssetsBundleConfiguration;
import io.dropwizard.bundles.assets.AssetsConfiguration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredAssetsBundle
implements ConfiguredBundle<AssetsBundleConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredAssetsBundle.class);
    private static final String DEFAULT_PATH = "/assets";
    public static final CacheBuilderSpec DEFAULT_CACHE_SPEC = CacheBuilderSpec.parse((String)"maximumSize=100");
    private static final String DEFAULT_INDEX_FILE = "index.htm";
    private static final String DEFAULT_SERVLET_MAPPING_NAME = "assets";
    private final Iterable<Map.Entry<String, String>> resourcePathToUriMappings;
    private final CacheBuilderSpec cacheBuilderSpec;
    private final String indexFile;
    private final String assetsName;

    public ConfiguredAssetsBundle() {
        this(DEFAULT_PATH);
    }

    public ConfiguredAssetsBundle(String path) {
        this(path, path, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath, String indexFile) {
        this(resourcePath, uriPath, indexFile, DEFAULT_SERVLET_MAPPING_NAME, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName) {
        this(resourcePath, uriPath, indexFile, assetsName, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(CacheBuilderSpec cacheBuilderSpec) {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(String resourcePath, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePath, resourcePath, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath, String indexFile, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePath, uriPath, indexFile, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName, CacheBuilderSpec cacheBuilderSpec) {
        this((Map<String, String>)ImmutableMap.builder().put((Object)resourcePath, (Object)uriPath).build(), indexFile, assetsName, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings) {
        this(resourcePathToUriMappings, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings, String indexFile) {
        this(resourcePathToUriMappings, indexFile, DEFAULT_SERVLET_MAPPING_NAME, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings, String indexFile, String assetsName) {
        this(resourcePathToUriMappings, indexFile, assetsName, DEFAULT_CACHE_SPEC);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePathToUriMappings, DEFAULT_INDEX_FILE, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings, String indexFile, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePathToUriMappings, indexFile, DEFAULT_SERVLET_MAPPING_NAME, cacheBuilderSpec);
    }

    public ConfiguredAssetsBundle(Map<String, String> resourcePathToUriMappings, String indexFile, String assetsName, CacheBuilderSpec cacheBuilderSpec) {
        for (Map.Entry<String, String> mapping : resourcePathToUriMappings.entrySet()) {
            String resourcePath = mapping.getKey();
            Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"%s is not an absolute path", (Object)resourcePath);
            Preconditions.checkArgument((!"/".equals(resourcePath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object)resourcePath);
        }
        this.resourcePathToUriMappings = Iterables.unmodifiableIterable(resourcePathToUriMappings.entrySet());
        this.cacheBuilderSpec = cacheBuilderSpec;
        this.indexFile = indexFile;
        this.assetsName = assetsName;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(AssetsBundleConfiguration bundleConfig, Environment env) throws Exception {
        AssetsConfiguration config = bundleConfig.getAssetsConfiguration();
        CacheBuilderSpec spec = config.getCacheSpec() != null ? CacheBuilderSpec.parse((String)config.getCacheSpec()) : this.cacheBuilderSpec;
        Set<Map.Entry<String, String>> overrides = config.getOverrides().entrySet();
        Set<Map.Entry<String, String>> mimeTypes = config.getMimeTypes().entrySet();
        Iterable<Map.Entry<String, String>> servletResourcePathToUriMappings = !config.getResourcePathToUriMappings().isEmpty() ? config.getResourcePathToUriMappings().entrySet() : this.resourcePathToUriMappings;
        AssetServlet servlet = new AssetServlet(servletResourcePathToUriMappings, this.indexFile, Charsets.UTF_8, spec, overrides, mimeTypes);
        for (Map.Entry<String, String> mapping : servletResourcePathToUriMappings) {
            String mappingPath = mapping.getValue();
            if (!mappingPath.endsWith("/")) {
                mappingPath = mappingPath + '/';
            }
            mappingPath = mappingPath + "*";
            servlet.setCacheControlHeader(config.getCacheControlHeader());
            LOGGER.info("Registering ConfiguredAssetBundle with name: {} for path {}", (Object)this.assetsName, (Object)mappingPath);
            env.servlets().addServlet(this.assetsName, (Servlet)servlet).addMapping(new String[]{mappingPath});
        }
    }
}

