/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.assets;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.dropwizard.Bundle;
import io.dropwizard.servlets.assets.AssetServlet;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.servlet.Servlet;

public class AssetsBundle
implements Bundle {
    private static final String DEFAULT_ASSETS_NAME = "assets";
    private static final String DEFAULT_INDEX_FILE = "index.htm";
    private static final String DEFAULT_PATH = "/assets";
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;
    private final String assetsName;

    public AssetsBundle() {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String path) {
        this(path, path, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile) {
        this(resourcePath, uriPath, indexFile, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"%s is not an absolute path", (Object[])new Object[]{resourcePath});
        Preconditions.checkArgument((!"/".equals(resourcePath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object[])new Object[]{resourcePath});
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + '/';
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + '/';
        this.indexFile = indexFile;
        this.assetsName = assetsName;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(Environment environment) {
        environment.servlets().addServlet(this.assetsName, (Servlet)this.createServlet()).addMapping(new String[]{this.uriPath + '*'});
    }

    private AssetServlet createServlet() {
        return new AssetServlet(this.resourcePath, this.uriPath, this.indexFile, Charsets.UTF_8);
    }
}

