/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.Authenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;

public class ChainedAuthFactory<T>
extends AuthFactory<Object, T> {
    private List<AuthFactory<?, T>> factories = null;

    public ChainedAuthFactory() {
        this(new ArrayList());
    }

    public ChainedAuthFactory(AuthFactory<?, T> ... providers) {
        this(Arrays.asList(providers));
    }

    public ChainedAuthFactory(List<AuthFactory<?, T>> factories) {
        super(null);
        this.factories = factories;
    }

    @Override
    public Authenticator<Object, T> authenticator() {
        return super.authenticator();
    }

    public boolean addChainedProvider(AuthFactory<?, T> provider) {
        return this.factories.add(provider);
    }

    public boolean removeChainedProvider(AuthFactory<?, T> provider) {
        return this.factories.remove(provider);
    }

    @Override
    public AuthFactory<Object, T> clone(boolean required) {
        ChainedAuthFactory<T> clone = new ChainedAuthFactory<T>();
        for (AuthFactory<?, T> factory : this.factories) {
            clone.addChainedProvider(factory.clone(required));
        }
        return clone;
    }

    @Override
    public Class<T> getGeneratedClass() {
        Class<T> generatedClass = null;
        for (AuthFactory<?, T> factory : this.factories) {
            if (generatedClass == null || generatedClass == factory.getGeneratedClass()) {
                generatedClass = factory.getGeneratedClass();
                continue;
            }
            throw new WebApplicationException("Chained auth factories must have the same generated class.");
        }
        return generatedClass;
    }

    @Override
    @Context
    public void setRequest(HttpServletRequest request) {
        for (AuthFactory<?, T> factory : this.factories) {
            factory.setRequest(request);
        }
    }

    public T provide() {
        WebApplicationException firstException = null;
        for (AuthFactory<?, T> factory : this.factories) {
            try {
                Object value = factory.provide();
                if (value == null) continue;
                return (T)value;
            }
            catch (WebApplicationException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException == null) {
            return null;
        }
        throw firstException;
    }
}

