/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.basic;

import com.google.common.base.Optional;
import com.google.common.io.BaseEncoding;
import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.auth.basic.BasicCredentials;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthFactory<T>
extends AuthFactory<BasicCredentials, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthFactory.class);
    private final boolean required;
    private final Class<T> generatedClass;
    private final String realm;
    private String prefix = "Basic";
    private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();
    @Context
    private HttpServletRequest request;

    public BasicAuthFactory(Authenticator<BasicCredentials, T> authenticator, String realm, Class<T> generatedClass) {
        super(authenticator);
        this.required = false;
        this.realm = realm;
        this.generatedClass = generatedClass;
    }

    private BasicAuthFactory(boolean required, Authenticator<BasicCredentials, T> authenticator, String realm, Class<T> generatedClass) {
        super(authenticator);
        this.required = required;
        this.realm = realm;
        this.generatedClass = generatedClass;
    }

    public BasicAuthFactory<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public BasicAuthFactory<T> responseBuilder(UnauthorizedHandler unauthorizedHandler) {
        this.unauthorizedHandler = unauthorizedHandler;
        return this;
    }

    @Override
    public AuthFactory<BasicCredentials, T> clone(boolean required) {
        return new BasicAuthFactory(required, this.authenticator(), this.realm, this.generatedClass).prefix(this.prefix).responseBuilder(this.unauthorizedHandler);
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public T provide() {
        if (this.request != null) {
            String header = this.request.getHeader("Authorization");
            try {
                String decoded;
                int i;
                String method;
                int space;
                if (header != null && (space = header.indexOf(32)) > 0 && this.prefix.equalsIgnoreCase(method = header.substring(0, space)) && (i = (decoded = new String(BaseEncoding.base64().decode((CharSequence)header.substring(space + 1)), StandardCharsets.UTF_8)).indexOf(58)) > 0) {
                    String username = decoded.substring(0, i);
                    String password = decoded.substring(i + 1);
                    BasicCredentials credentials = new BasicCredentials(username, password);
                    Optional result = this.authenticator().authenticate(credentials);
                    if (result.isPresent()) {
                        return (T)result.get();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Error decoding credentials", (Throwable)e);
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Error authenticating credentials", (Throwable)e);
                throw new InternalServerErrorException();
            }
        }
        if (this.required) {
            throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
        }
        return null;
    }

    @Override
    public Class<T> getGeneratedClass() {
        return this.generatedClass;
    }
}

