/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.google.common.collect.ImmutableMap;
import io.dropwizard.auth.Auth;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class PolymorphicAuthDynamicFeature<T extends Principal>
implements DynamicFeature {
    private final ImmutableMap<Class<? extends T>, ContainerRequestFilter> authFilterMap;

    public PolymorphicAuthDynamicFeature(ImmutableMap<Class<? extends T>, ContainerRequestFilter> authFilterMap) {
        this.authFilterMap = authFilterMap;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        Class[] parameterTypes = am.getParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Auth) || !this.authFilterMap.containsKey((Object)parameterTypes[i])) continue;
                context.register(this.authFilterMap.get((Object)parameterTypes[i]));
                return;
            }
        }
    }
}

