/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.google.common.base.Preconditions;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.PermitAllAuthorizer;
import io.dropwizard.auth.UnauthorizedHandler;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public abstract class AuthFilter<C, P extends Principal>
implements ContainerRequestFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String prefix;
    protected String realm;
    protected Authenticator<C, P> authenticator;
    protected Authorizer<P> authorizer;
    protected UnauthorizedHandler unauthorizedHandler;

    protected boolean authenticate(ContainerRequestContext requestContext, C credentials, final String scheme) {
        try {
            if (credentials == null) {
                return false;
            }
            final Optional<P> principal = this.authenticator.authenticate(credentials);
            if (!principal.isPresent()) {
                return false;
            }
            SecurityContext securityContext = requestContext.getSecurityContext();
            final boolean secure = securityContext != null && securityContext.isSecure();
            requestContext.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return (Principal)principal.get();
                }

                public boolean isUserInRole(String role) {
                    return AuthFilter.this.authorizer.authorize((Principal)principal.get(), role);
                }

                public boolean isSecure() {
                    return secure;
                }

                public String getAuthenticationScheme() {
                    return scheme;
                }
            });
            return true;
        }
        catch (AuthenticationException e) {
            this.logger.warn("Error authenticating credentials", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static abstract class AuthFilterBuilder<C, P extends Principal, T extends AuthFilter<C, P>> {
        private String realm = "realm";
        private String prefix = "Basic";
        private Authenticator<C, P> authenticator;
        private Authorizer<P> authorizer = new PermitAllAuthorizer();
        private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();

        public AuthFilterBuilder<C, P, T> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthorizer(Authorizer<P> authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthenticator(Authenticator<C, P> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setUnauthorizedHandler(UnauthorizedHandler unauthorizedHandler) {
            this.unauthorizedHandler = unauthorizedHandler;
            return this;
        }

        public T buildAuthFilter() {
            Preconditions.checkNotNull((Object)this.realm, (Object)"Realm is not set");
            Preconditions.checkNotNull((Object)this.prefix, (Object)"Prefix is not set");
            Preconditions.checkNotNull(this.authenticator, (Object)"Authenticator is not set");
            Preconditions.checkNotNull(this.authorizer, (Object)"Authorizer is not set");
            Preconditions.checkNotNull((Object)this.unauthorizedHandler, (Object)"Unauthorized handler is not set");
            T authFilter = this.newInstance();
            ((AuthFilter)authFilter).authorizer = this.authorizer;
            ((AuthFilter)authFilter).authenticator = this.authenticator;
            ((AuthFilter)authFilter).prefix = this.prefix;
            ((AuthFilter)authFilter).realm = this.realm;
            ((AuthFilter)authFilter).unauthorizedHandler = this.unauthorizedHandler;
            return authFilter;
        }

        protected abstract T newInstance();
    }
}

