/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.auth.Authorizer;
import java.security.Principal;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CachingAuthorizer<P extends Principal>
implements Authorizer<P> {
    private final Authorizer<P> underlying;
    private final Meter cacheMisses;
    private final Timer getsTimer;
    private final LoadingCache<ImmutablePair<P, String>, Boolean> cache;

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CacheBuilderSpec cacheSpec) {
        this(metricRegistry, authorizer, (CacheBuilder<Object, Object>)CacheBuilder.from((CacheBuilderSpec)cacheSpec));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CacheBuilder<Object, Object> builder) {
        this.underlying = authorizer;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authorizer.getClass(), (String[])new String[]{"cache-misses"}));
        this.getsTimer = metricRegistry.timer(MetricRegistry.name(authorizer.getClass(), (String[])new String[]{"gets"}));
        this.cache = builder.recordStats().build(new CacheLoader<ImmutablePair<P, String>, Boolean>(){

            public Boolean load(ImmutablePair<P, String> key) throws Exception {
                CachingAuthorizer.this.cacheMisses.mark();
                return CachingAuthorizer.this.underlying.authorize((Principal)key.left, (String)key.right);
            }
        });
    }

    @Override
    public boolean authorize(P principal, String role) {
        Timer.Context context = this.getsTimer.time();
        try {
            ImmutablePair cacheKey = ImmutablePair.of(principal, (Object)role);
            boolean bl = (Boolean)this.cache.getUnchecked((Object)cacheKey);
            return bl;
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        finally {
            context.stop();
        }
    }

    public void invalidate(P principal, String role) {
        this.cache.invalidate((Object)ImmutablePair.of(principal, (Object)role));
    }

    public void invalidate(P principal) {
        Predicate<ImmutablePair> predicate = cacheKey -> ((Principal)cacheKey.getLeft()).equals(principal);
        this.cache.invalidateAll((Iterable)Sets.filter(this.cache.asMap().keySet(), predicate::test));
    }

    public void invalidateAll(Iterable<P> principals) {
        Predicate<ImmutablePair> predicate = cacheKey -> Iterables.contains((Iterable)principals, (Object)cacheKey.getLeft());
        this.cache.invalidateAll((Iterable)Sets.filter(this.cache.asMap().keySet(), predicate::test));
    }

    public void invalidateAll(Predicate<? super P> predicate) {
        Predicate<ImmutablePair> nestedPredicate = cacheKey -> predicate.test((Object)cacheKey.getLeft());
        this.cache.invalidateAll((Iterable)Sets.filter(this.cache.asMap().keySet(), nestedPredicate::test));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

