/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.chained;

import io.dropwizard.auth.AuthFilter;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;

@Priority(value=1000)
public class ChainedAuthFilter<C, P extends Principal>
extends AuthFilter<C, P> {
    private final List<AuthFilter> handlers;

    public ChainedAuthFilter(List<AuthFilter> handlers) {
        this.handlers = handlers;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        WebApplicationException firstException = null;
        for (AuthFilter authFilter : this.handlers) {
            SecurityContext securityContext = containerRequestContext.getSecurityContext();
            try {
                authFilter.filter(containerRequestContext);
                if (securityContext == containerRequestContext.getSecurityContext()) continue;
                return;
            }
            catch (WebApplicationException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException == null) {
            throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
        }
        throw firstException;
    }
}

