/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CachingAuthenticator<C, P extends Principal>
implements Authenticator<C, P> {
    private final LoadingCache<C, Optional<P>> cache;
    private final Meter cacheMisses;
    private final Timer gets;

    public CachingAuthenticator(MetricRegistry metricRegistry, Authenticator<C, P> authenticator, CaffeineSpec cacheSpec) {
        this(metricRegistry, authenticator, (Caffeine<Object, Object>)Caffeine.from((CaffeineSpec)cacheSpec));
    }

    public CachingAuthenticator(MetricRegistry metricRegistry, Authenticator<C, P> authenticator, Caffeine<Object, Object> builder) {
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"cache-misses"}));
        this.gets = metricRegistry.timer(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"gets"}));
        this.cache = builder.recordStats().build(key -> {
            this.cacheMisses.mark();
            Optional optPrincipal = authenticator.authenticate(key);
            if (!optPrincipal.isPresent()) {
                throw new InvalidCredentialsException();
            }
            return optPrincipal;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<P> authenticate(C credentials) throws AuthenticationException {
        try (Timer.Context context = this.gets.time();){
            Optional throwable3 = (Optional)this.cache.get(credentials);
            return throwable3;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidCredentialsException) {
                return Optional.empty();
            }
            if (!(cause instanceof AuthenticationException)) throw new AuthenticationException(cause);
            throw (AuthenticationException)cause;
        }
    }

    public void invalidate(C credentials) {
        this.cache.invalidate(credentials);
    }

    public void invalidateAll(Iterable<C> credentials) {
        this.cache.invalidateAll(credentials);
    }

    public void invalidateAll(Predicate<? super C> predicate) {
        Set keys = this.cache.asMap().keySet().stream().filter(predicate).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    private static class InvalidCredentialsException
    extends Exception {
        private InvalidCredentialsException() {
        }
    }
}

