/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.caffeine.MetricsStatsCounter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.dropwizard.auth.AuthorizationContext;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.util.Sets;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;

public class CachingAuthorizer<P extends Principal>
implements Authorizer<P> {
    private final Authorizer<P> underlying;
    private final Meter cacheMisses;
    private final Timer getsTimer;
    final LoadingCache<AuthorizationContext<P>, Boolean> cache;

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CaffeineSpec cacheSpec) {
        this(metricRegistry, authorizer, (Caffeine<Object, Object>)Caffeine.from((CaffeineSpec)cacheSpec));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, Caffeine<Object, Object> builder) {
        this(metricRegistry, authorizer, builder, () -> new MetricsStatsCounter(metricRegistry, MetricRegistry.name(CachingAuthorizer.class, (String[])new String[0])));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, Caffeine<Object, Object> builder, Supplier<StatsCounter> supplier) {
        this.underlying = authorizer;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authorizer.getClass(), (String[])new String[]{"cache-misses"}));
        this.getsTimer = metricRegistry.timer(MetricRegistry.name(authorizer.getClass(), (String[])new String[]{"gets"}));
        this.cache = builder.recordStats(supplier).build(key -> {
            this.cacheMisses.mark();
            return this.underlying.authorize(key.getPrincipal(), key.getRole(), key.getRequestContext());
        });
    }

    @Override
    public boolean authorize(P principal, String role) {
        return this.authorize(principal, role, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean authorize(P principal, String role, @Nullable ContainerRequestContext requestContext) {
        try (Timer.Context context = this.getsTimer.time();){
            AuthorizationContext<P> cacheKey = this.getAuthorizationContext(principal, role, requestContext);
            boolean bl = Boolean.TRUE.equals(this.cache.get(cacheKey));
            return bl;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (!(cause instanceof Error)) throw e;
            throw (Error)cause;
        }
    }

    @Override
    public AuthorizationContext<P> getAuthorizationContext(P principal, String role, @Nullable ContainerRequestContext requestContext) {
        return this.underlying.getAuthorizationContext(principal, role, requestContext);
    }

    public void invalidate(P principal, String role, ContainerRequestContext requestContext) {
        this.cache.invalidate(this.getAuthorizationContext(principal, role, requestContext));
    }

    public void invalidate(P principal) {
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> cacheKey.getPrincipal().equals(principal)).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll(Iterable<P> principals) {
        Set principalSet = Sets.of(principals);
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> principalSet.contains(cacheKey.getPrincipal())).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll(Predicate<? super P> predicate) {
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> predicate.test((Object)cacheKey.getPrincipal())).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

