/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.OptionalPrincipalContainerRequestValueFactory;
import io.dropwizard.auth.PrincipalContainerRequestValueFactory;
import java.lang.reflect.ParameterizedType;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

@Singleton
public class PolymorphicAuthValueFactoryProvider<T extends Principal>
extends AbstractValueParamProvider {
    protected final Set<Class<? extends T>> principalClassSet;

    @Inject
    public PolymorphicAuthValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, PrincipalClassSetProvider<T> principalClassSetProvider) {
        super(() -> mpep, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.principalClassSet = principalClassSetProvider.clazzSet;
    }

    protected @Nullable Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        if (!parameter.isAnnotationPresent(Auth.class)) {
            return null;
        }
        if (this.principalClassSet.contains(parameter.getRawType())) {
            return request -> new PrincipalContainerRequestValueFactory((ContainerRequest)request).provide();
        }
        boolean isOptionalPrincipal = parameter.getRawType() == Optional.class && ParameterizedType.class.isAssignableFrom(parameter.getType().getClass()) && this.principalClassSet.contains(((ParameterizedType)parameter.getType()).getActualTypeArguments()[0]);
        return isOptionalPrincipal ? request -> new OptionalPrincipalContainerRequestValueFactory((ContainerRequest)request).provide() : null;
    }

    public static class Binder<T extends Principal>
    extends AbstractBinder {
        private final Set<Class<? extends T>> principalClassSet;

        public Binder(Set<Class<? extends T>> principalClassSet) {
            this.principalClassSet = principalClassSet;
        }

        protected void configure() {
            this.bind(new PrincipalClassSetProvider<T>(this.principalClassSet)).to(PrincipalClassSetProvider.class);
            ((ClassBinding)this.bind(PolymorphicAuthValueFactoryProvider.class).to(ValueParamProvider.class)).in(Singleton.class);
        }
    }

    @Singleton
    protected static class PrincipalClassSetProvider<T extends Principal> {
        private final Set<Class<? extends T>> clazzSet;

        public PrincipalClassSetProvider(Set<Class<? extends T>> clazzSet) {
            this.clazzSet = clazzSet;
        }
    }
}

