/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.JettyAuthenticationUtil;
import io.dropwizard.auth.PermitAllAuthorizer;
import io.dropwizard.auth.UnauthorizedHandler;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public abstract class AuthFilter<C, P extends Principal>
implements ContainerRequestFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String prefix = "Basic";
    protected String realm = "realm";
    protected Authenticator<C, P> authenticator = credentials -> Optional.empty();
    protected Authorizer<P> authorizer = new PermitAllAuthorizer();
    protected UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();
    @Inject
    private @Nullable InjectionManager injectionManager;

    protected boolean authenticate(final ContainerRequestContext requestContext, @Nullable C credentials, final String scheme) {
        try {
            if (credentials == null) {
                return false;
            }
            Optional<P> principal = this.authenticator.authenticate(credentials);
            if (principal.isEmpty()) {
                return false;
            }
            final Principal prince = (Principal)principal.get();
            SecurityContext securityContext = requestContext.getSecurityContext();
            final boolean secure = securityContext != null && securityContext.isSecure();
            SecurityContext dropwizardAuthenticatedSecurityContext = new SecurityContext(){

                public Principal getUserPrincipal() {
                    return prince;
                }

                public boolean isUserInRole(String role) {
                    return AuthFilter.this.authorizer.authorize(prince, role, requestContext);
                }

                public boolean isSecure() {
                    return secure;
                }

                public String getAuthenticationScheme() {
                    return scheme;
                }
            };
            requestContext.setSecurityContext(dropwizardAuthenticatedSecurityContext);
            JettyAuthenticationUtil.setJettyAuthenticationIfPossible(dropwizardAuthenticatedSecurityContext, this.injectionManager);
            return true;
        }
        catch (AuthenticationException e) {
            this.logger.warn("Error authenticating credentials", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static abstract class AuthFilterBuilder<C, P extends Principal, T extends AuthFilter<C, P>> {
        private String realm = "realm";
        private String prefix = "Basic";
        private Authenticator<C, P> authenticator = credentials -> Optional.empty();
        private Authorizer<P> authorizer = new PermitAllAuthorizer();
        private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();

        public AuthFilterBuilder<C, P, T> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthorizer(Authorizer<P> authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthenticator(Authenticator<C, P> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setUnauthorizedHandler(UnauthorizedHandler unauthorizedHandler) {
            this.unauthorizedHandler = unauthorizedHandler;
            return this;
        }

        public T buildAuthFilter() {
            Objects.requireNonNull(this.realm, "Realm is not set");
            Objects.requireNonNull(this.prefix, "Prefix is not set");
            Objects.requireNonNull(this.authenticator, "Authenticator is not set");
            Objects.requireNonNull(this.authorizer, "Authorizer is not set");
            Objects.requireNonNull(this.unauthorizedHandler, "Unauthorized handler is not set");
            T authFilter = this.newInstance();
            ((AuthFilter)authFilter).authorizer = this.authorizer;
            ((AuthFilter)authFilter).authenticator = this.authenticator;
            ((AuthFilter)authFilter).prefix = this.prefix;
            ((AuthFilter)authFilter).realm = this.realm;
            ((AuthFilter)authFilter).unauthorizedHandler = this.unauthorizedHandler;
            return authFilter;
        }

        protected abstract T newInstance();
    }
}

