/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.oauth;

import io.dropwizard.auth.AuthFilter;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import org.checkerframework.checker.nullness.qual.Nullable;

@Priority(value=1000)
public class OAuthCredentialAuthFilter<P extends Principal>
extends AuthFilter<String, P> {
    public static final String OAUTH_ACCESS_TOKEN_PARAM = "access_token";

    private OAuthCredentialAuthFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String credentials = this.getCredentials((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
        if (credentials == null) {
            credentials = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)OAUTH_ACCESS_TOKEN_PARAM);
        }
        if (!this.authenticate(requestContext, credentials, "BASIC")) {
            throw this.unauthorizedHandler.buildException(this.prefix, this.realm);
        }
    }

    private @Nullable String getCredentials(String header) {
        if (header == null) {
            return null;
        }
        int space = header.indexOf(32);
        if (space <= 0) {
            return null;
        }
        String method = header.substring(0, space);
        if (!this.prefix.equalsIgnoreCase(method)) {
            return null;
        }
        return header.substring(space + 1);
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<String, P, OAuthCredentialAuthFilter<P>> {
        @Override
        protected OAuthCredentialAuthFilter<P> newInstance() {
            return new OAuthCredentialAuthFilter();
        }
    }
}

