/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthInjectionHelper;
import io.dropwizard.auth.WebApplicationExceptionCatchingFilter;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.InjectionManagerProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class AuthDynamicFeature
implements Feature,
DynamicFeature {
    private final ContainerRequestFilter authFilter;
    private final Class<? extends ContainerRequestFilter> authFilterClass;

    public AuthDynamicFeature(ContainerRequestFilter authFilter) {
        this.authFilter = authFilter;
        this.authFilterClass = null;
    }

    public AuthDynamicFeature(Class<? extends ContainerRequestFilter> authFilterClass) {
        this.authFilter = null;
        this.authFilterClass = authFilterClass;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        boolean annotationOnMethod;
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        Class[] parameterTypes = am.getParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (!this.containsAuthAnnotation(parameterAnnotations[i])) continue;
            if (parameterTypes[i].equals(Optional.class) && this.authFilter != null) {
                this.registerAuthFilter(context, new WebApplicationExceptionCatchingFilter(this.authFilter));
            } else {
                this.registerAuthFilter(context);
            }
            return;
        }
        boolean annotationOnClass = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class) != null || resourceInfo.getResourceClass().getAnnotation(PermitAll.class) != null;
        boolean bl = annotationOnMethod = am.isAnnotationPresent(RolesAllowed.class) || am.isAnnotationPresent(DenyAll.class) || am.isAnnotationPresent(PermitAll.class);
        if (annotationOnClass || annotationOnMethod) {
            this.registerAuthFilter(context);
        }
    }

    private boolean containsAuthAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Auth)) continue;
            return true;
        }
        return false;
    }

    private void registerAuthFilter(FeatureContext context) {
        this.registerAuthFilter(context, null);
    }

    private void registerAuthFilter(FeatureContext context, @Nullable ContainerRequestFilter decoratedAuthFilter) {
        if (decoratedAuthFilter != null) {
            context.register((Object)decoratedAuthFilter);
        } else if (this.authFilter != null) {
            context.register((Object)this.authFilter);
        } else if (this.authFilterClass != null) {
            context.register(this.authFilterClass);
        }
    }

    public boolean configure(FeatureContext context) {
        try {
            InjectionManager injectionManager;
            if (this.authFilter != null && (injectionManager = InjectionManagerProvider.getInjectionManager((FeatureContext)context)) != null) {
                AuthInjectionHelper.inject(injectionManager, this.authFilter);
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

