/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.Subject;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.security.AbstractUserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Ref;

class JettyAuthenticationUtil {
    private static final Type HTTP_SERVLET_REQUEST_REF_TYPE = new GenericType<Ref<HttpServletRequest>>(){}.getType();

    JettyAuthenticationUtil() {
    }

    static void setJettyAuthenticationIfPossible(SecurityContext securityContext, @Nullable InjectionManager injectionManager) {
        if (injectionManager == null) {
            return;
        }
        Ref requestRef = (Ref)injectionManager.getInstance(HTTP_SERVLET_REQUEST_REF_TYPE);
        if (requestRef == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)requestRef.get();
        if (!(request instanceof Request)) {
            return;
        }
        Request jettyRequest = (Request)request;
        DropwizardJettyAuthentication authentication = new DropwizardJettyAuthentication(securityContext);
        jettyRequest.setAuthentication((Authentication)authentication);
    }

    private static class DropwizardJettyUserIdentity
    implements UserIdentity {
        private final Subject subject;
        private final SecurityContext securityContext;

        public DropwizardJettyUserIdentity(SecurityContext securityContext) {
            this.securityContext = securityContext;
            this.subject = new Subject(true, Set.of(securityContext.getUserPrincipal()), Set.of(), Set.of());
        }

        public Subject getSubject() {
            return this.subject;
        }

        public Principal getUserPrincipal() {
            return this.securityContext.getUserPrincipal();
        }

        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
            if ("*".equals(role)) {
                return false;
            }
            String resolvedRole = Optional.ofNullable(scope).map(UserIdentity.Scope::getRoleRefMap).map(roleMap -> (String)roleMap.get(role)).orElse(role);
            return this.securityContext.isUserInRole(resolvedRole);
        }
    }

    private static class DropwizardJettyAuthentication
    extends AbstractUserAuthentication {
        public DropwizardJettyAuthentication(SecurityContext securityContext) {
            super(securityContext.getAuthenticationScheme(), (UserIdentity)new DropwizardJettyUserIdentity(securityContext));
        }
    }
}

