/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import com.sun.jersey.client.apache4.config.ApacheHttpClient4Config;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;

public class JerseyClientBuilder {
    private final HttpClientBuilder builder;
    private final List<Object> singletons = Lists.newArrayList();
    private final List<Class<?>> providers = Lists.newArrayList();
    private final Map<String, Boolean> features = Maps.newLinkedHashMap();
    private final Map<String, Object> properties = Maps.newLinkedHashMap();
    private JerseyClientConfiguration configuration = new JerseyClientConfiguration();
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private Environment environment;
    private ObjectMapper objectMapper;
    private ExecutorService executorService;

    public JerseyClientBuilder(Environment environment) {
        this.builder = new HttpClientBuilder(environment);
        this.environment = environment;
    }

    public JerseyClientBuilder(MetricRegistry metricRegistry) {
        this.builder = new HttpClientBuilder(metricRegistry);
    }

    public JerseyClientBuilder withProvider(Object provider) {
        this.singletons.add(Preconditions.checkNotNull((Object)provider));
        return this;
    }

    public JerseyClientBuilder withProvider(Class<?> klass) {
        this.providers.add((Class<?>)Preconditions.checkNotNull(klass));
        return this;
    }

    public JerseyClientBuilder withFeature(String featureName, boolean featureState) {
        this.features.put(featureName, featureState);
        return this;
    }

    public JerseyClientBuilder withProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public JerseyClientBuilder using(JerseyClientConfiguration configuration) {
        this.configuration = configuration;
        this.builder.using(configuration);
        return this;
    }

    public JerseyClientBuilder using(Environment environment) {
        this.environment = environment;
        return this;
    }

    public JerseyClientBuilder using(DnsResolver resolver) {
        this.builder.using(resolver);
        return this;
    }

    public JerseyClientBuilder using(SchemeRegistry registry) {
        this.builder.using(registry);
        return this;
    }

    public JerseyClientBuilder using(Validator validator) {
        this.validator = validator;
        return this;
    }

    public JerseyClientBuilder using(ExecutorService executorService, ObjectMapper objectMapper) {
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        return this;
    }

    public Client build(String name) {
        if (this.environment == null && this.executorService == null && this.objectMapper == null) {
            throw new IllegalStateException("Must have either an environment or both an executor service and an object mapper");
        }
        if (this.environment == null) {
            return this.build(this.executorService, this.objectMapper, this.validator, name);
        }
        return this.build(this.environment.lifecycle().executorService("jersey-client-" + name + "-%d").minThreads(this.configuration.getMinThreads()).maxThreads(this.configuration.getMaxThreads()).build(), this.environment.getObjectMapper(), this.environment.getValidator(), name);
    }

    private Client build(ExecutorService threadPool, ObjectMapper objectMapper, Validator validator, String name) {
        ApacheHttpClient4 client = new ApacheHttpClient4(this.buildHandler(name), (ClientConfig)this.buildConfig(objectMapper));
        client.setExecutorService(threadPool);
        if (this.configuration.isGzipEnabled()) {
            client.addFilter((ClientFilter)new GZIPContentEncodingFilter(this.configuration.isGzipEnabledForRequests()));
        }
        return client;
    }

    private ApacheHttpClient4Handler buildHandler(String name) {
        return new ApacheHttpClient4Handler(this.builder.build(name), null, true);
    }

    private ApacheHttpClient4Config buildConfig(ObjectMapper objectMapper) {
        DefaultApacheHttpClient4Config config = new DefaultApacheHttpClient4Config();
        config.getSingletons().addAll(this.singletons);
        config.getSingletons().add(new JacksonMessageBodyProvider(objectMapper, this.validator));
        config.getClasses().addAll(this.providers);
        config.getFeatures().putAll(this.features);
        config.getProperties().putAll(this.properties);
        return config;
    }
}

