/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.dropwizard.client.DropwizardApacheConnector;
import io.dropwizard.client.DropwizardExecutorProvider;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.jersey.gzip.ConfiguredGZipEncoder;
import io.dropwizard.jersey.gzip.GZipDecoder;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.Registry;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class JerseyClientBuilder {
    private final List<Object> singletons = Lists.newArrayList();
    private final List<Class<?>> providers = Lists.newArrayList();
    private final Map<String, Object> properties = Maps.newLinkedHashMap();
    private JerseyClientConfiguration configuration = new JerseyClientConfiguration();
    private HttpClientBuilder apacheHttpClientBuilder;
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private Environment environment;
    private ObjectMapper objectMapper;
    private ExecutorService executorService;
    private ConnectorProvider connectorProvider;

    public JerseyClientBuilder(Environment environment) {
        this.apacheHttpClientBuilder = new HttpClientBuilder(environment);
        this.environment = environment;
    }

    public JerseyClientBuilder(MetricRegistry metricRegistry) {
        this.apacheHttpClientBuilder = new HttpClientBuilder(metricRegistry);
    }

    @VisibleForTesting
    public void setApacheHttpClientBuilder(HttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    public JerseyClientBuilder withProvider(Object provider) {
        this.singletons.add(Preconditions.checkNotNull((Object)provider));
        return this;
    }

    public JerseyClientBuilder withProvider(Class<?> klass) {
        this.providers.add((Class<?>)Preconditions.checkNotNull(klass));
        return this;
    }

    public JerseyClientBuilder withProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public JerseyClientBuilder using(JerseyClientConfiguration configuration) {
        this.configuration = configuration;
        this.apacheHttpClientBuilder.using(configuration);
        return this;
    }

    public JerseyClientBuilder using(Environment environment) {
        this.environment = environment;
        return this;
    }

    public JerseyClientBuilder using(Validator validator) {
        this.validator = validator;
        return this;
    }

    public JerseyClientBuilder using(ExecutorService executorService, ObjectMapper objectMapper) {
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        return this;
    }

    public JerseyClientBuilder using(ConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
        return this;
    }

    public JerseyClientBuilder using(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.apacheHttpClientBuilder.using(httpRequestRetryHandler);
        return this;
    }

    public JerseyClientBuilder using(DnsResolver resolver) {
        this.apacheHttpClientBuilder.using(resolver);
        return this;
    }

    public JerseyClientBuilder using(Registry<ConnectionSocketFactory> registry) {
        this.apacheHttpClientBuilder.using(registry);
        return this;
    }

    public JerseyClientBuilder using(HttpClientMetricNameStrategy metricNameStrategy) {
        this.apacheHttpClientBuilder.using(metricNameStrategy);
        return this;
    }

    public JerseyClientBuilder name(String environmentName) {
        this.apacheHttpClientBuilder.name(environmentName);
        return this;
    }

    public JerseyClientBuilder using(HttpRoutePlanner routePlanner) {
        this.apacheHttpClientBuilder.using(routePlanner);
        return this;
    }

    public JerseyClientBuilder using(CredentialsProvider credentialsProvider) {
        this.apacheHttpClientBuilder.using(credentialsProvider);
        return this;
    }

    public Client build(String name) {
        if (this.environment == null && (this.executorService == null || this.objectMapper == null)) {
            throw new IllegalStateException("Must have either an environment or both an executor service and an object mapper");
        }
        if (this.environment == null) {
            return this.build(name, this.executorService, this.objectMapper, this.validator);
        }
        return this.build(name, this.environment.lifecycle().executorService("jersey-client-" + name + "-%d").minThreads(this.configuration.getMinThreads()).maxThreads(this.configuration.getMaxThreads()).build(), this.environment.getObjectMapper(), this.environment.getValidator());
    }

    private Client build(String name, ExecutorService threadPool, ObjectMapper objectMapper, Validator validator) {
        Client client = ClientBuilder.newClient((Configuration)this.buildConfig(name, threadPool, objectMapper, validator));
        if (this.configuration.isGzipEnabled()) {
            client.register((Object)new GZipDecoder());
            client.register((Object)new ConfiguredGZipEncoder(this.configuration.isGzipEnabledForRequests()));
        }
        return client;
    }

    private Configuration buildConfig(final String name, ExecutorService threadPool, ObjectMapper objectMapper, Validator validator) {
        ClientConfig config = new ClientConfig();
        for (Object object : this.singletons) {
            config.register(object);
        }
        for (Class clazz : this.providers) {
            config.register(clazz);
        }
        config.register((Object)new JacksonMessageBodyProvider(objectMapper, validator));
        for (Map.Entry entry : this.properties.entrySet()) {
            config.property((String)entry.getKey(), entry.getValue());
        }
        config.register((Object)new DropwizardExecutorProvider(threadPool));
        if (this.connectorProvider == null) {
            this.connectorProvider = new ConnectorProvider(){

                public Connector getConnector(Client client, Configuration runtimeConfig) {
                    return new DropwizardApacheConnector(JerseyClientBuilder.this.apacheHttpClientBuilder.build(name), JerseyClientBuilder.this.configuration.isChunkedEncodingEnabled());
                }
            };
        }
        config.connectorProvider(this.connectorProvider);
        return config;
    }
}

