/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.VersionInfo;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.Statuses;

public class DropwizardApacheConnector
implements Connector {
    private static final String APACHE_HTTP_CLIENT_VERSION = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)DropwizardApacheConnector.class.getClassLoader()).getRelease();
    private final CloseableHttpClient client;
    private final RequestConfig defaultRequestConfig;
    private final boolean chunkedEncodingEnabled;

    public DropwizardApacheConnector(CloseableHttpClient client, RequestConfig defaultRequestConfig, boolean chunkedEncodingEnabled) {
        this.client = client;
        this.defaultRequestConfig = defaultRequestConfig;
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    public ClientResponse apply(ClientRequest jerseyRequest) {
        try {
            HttpUriRequest apacheRequest = this.buildApacheRequest(jerseyRequest);
            CloseableHttpResponse apacheResponse = this.client.execute(apacheRequest);
            StatusLine statusLine = apacheResponse.getStatusLine();
            Response.StatusType status = Statuses.from((int)statusLine.getStatusCode(), (String)((String)MoreObjects.firstNonNull((Object)statusLine.getReasonPhrase(), (Object)"")));
            ClientResponse jerseyResponse = new ClientResponse(status, jerseyRequest);
            for (Header header : apacheResponse.getAllHeaders()) {
                List headerValues = (List)jerseyResponse.getHeaders().get((Object)header.getName());
                if (headerValues == null) {
                    jerseyResponse.getHeaders().put((Object)header.getName(), (Object)Lists.newArrayList((Object[])new String[]{header.getValue()}));
                    continue;
                }
                headerValues.add(header.getValue());
            }
            HttpEntity httpEntity = apacheResponse.getEntity();
            jerseyResponse.setEntityStream(httpEntity != null ? httpEntity.getContent() : new ByteArrayInputStream(new byte[0]));
            return jerseyResponse;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private HttpUriRequest buildApacheRequest(ClientRequest jerseyRequest) {
        RequestBuilder builder = RequestBuilder.create((String)jerseyRequest.getMethod()).setUri(jerseyRequest.getUri()).setEntity(this.getHttpEntity(jerseyRequest));
        for (String headerName : jerseyRequest.getHeaders().keySet()) {
            builder.addHeader(headerName, jerseyRequest.getHeaderString(headerName));
        }
        Optional<RequestConfig> requestConfig = this.addJerseyRequestConfig(jerseyRequest);
        requestConfig.ifPresent(arg_0 -> ((RequestBuilder)builder).setConfig(arg_0));
        return builder.build();
    }

    private Optional<RequestConfig> addJerseyRequestConfig(ClientRequest clientRequest) {
        Integer timeout = (Integer)clientRequest.resolveProperty("jersey.config.client.readTimeout", Integer.class);
        Integer connectTimeout = (Integer)clientRequest.resolveProperty("jersey.config.client.connectTimeout", Integer.class);
        Boolean followRedirects = (Boolean)clientRequest.resolveProperty("jersey.config.client.followRedirects", Boolean.class);
        if (timeout != null || connectTimeout != null || followRedirects != null) {
            RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
            if (timeout != null) {
                requestConfig.setSocketTimeout(timeout.intValue());
            }
            if (connectTimeout != null) {
                requestConfig.setConnectTimeout(connectTimeout.intValue());
            }
            if (followRedirects != null) {
                requestConfig.setRedirectsEnabled(followRedirects.booleanValue());
            }
            return Optional.of(requestConfig.build());
        }
        return Optional.empty();
    }

    private HttpEntity getHttpEntity(ClientRequest jerseyRequest) {
        if (jerseyRequest.getEntity() == null) {
            return null;
        }
        return this.chunkedEncodingEnabled ? new JerseyRequestHttpEntity(jerseyRequest) : new BufferedJerseyRequestHttpEntity(jerseyRequest);
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        return MoreExecutors.newDirectExecutorService().submit(() -> {
            try {
                callback.response(this.apply(request));
            }
            catch (Exception e) {
                callback.failure((Throwable)e);
            }
        });
    }

    public String getName() {
        return "Apache-HttpClient/" + APACHE_HTTP_CLIENT_VERSION;
    }

    public void close() {
    }

    private static class BufferedJerseyRequestHttpEntity
    extends AbstractHttpEntity {
        private static final int BUFFER_INITIAL_SIZE = 512;
        private byte[] buffer;

        private BufferedJerseyRequestHttpEntity(ClientRequest clientRequest) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(512);
            clientRequest.setStreamProvider(contentLength -> stream);
            try {
                clientRequest.writeEntity();
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), (Throwable)e);
            }
            this.buffer = stream.toByteArray();
            this.setChunked(false);
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.buffer.length;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException("Reading from the entity is not supported");
        }

        public void writeTo(OutputStream outstream) throws IOException {
            outstream.write(this.buffer);
            outstream.flush();
        }

        public boolean isStreaming() {
            return false;
        }
    }

    private static class JerseyRequestHttpEntity
    extends AbstractHttpEntity {
        private ClientRequest clientRequest;

        private JerseyRequestHttpEntity(ClientRequest clientRequest) {
            this.clientRequest = clientRequest;
            this.setChunked(true);
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException("Reading from the entity is not supported");
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.clientRequest.setStreamProvider(contentLength -> outputStream);
            this.clientRequest.writeEntity();
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

