/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.google.common.util.concurrent.ForwardingExecutorService;
import io.dropwizard.util.Duration;
import java.util.concurrent.ExecutorService;
import org.glassfish.jersey.client.ClientAsyncExecutor;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientAsyncExecutor
class DropwizardExecutorProvider
implements ExecutorServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardExecutorProvider.class);
    private final ExecutorService executor;
    private final Duration shutdownGracePeriod;

    DropwizardExecutorProvider(ExecutorService executor, Duration shutdownGracePeriod) {
        this.executor = executor;
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public void dispose(ExecutorService executorService) {
        if (executorService instanceof DisposableExecutorService) {
            executorService.shutdown();
            try {
                executorService.awaitTermination(this.shutdownGracePeriod.getQuantity(), this.shutdownGracePeriod.getUnit());
            }
            catch (InterruptedException err) {
                LOGGER.warn("Interrupted while waiting for ExecutorService shutdown", (Throwable)err);
            }
        }
    }

    static class DisposableExecutorService
    extends ForwardingExecutorService {
        private final ExecutorService delegate;

        public DisposableExecutorService(ExecutorService delegate) {
            this.delegate = delegate;
        }

        protected ExecutorService delegate() {
            return this.delegate;
        }
    }
}

