/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.client.proxy.ProxyConfiguration;
import io.dropwizard.client.ssl.TlsConfiguration;
import io.dropwizard.util.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.valuehandling.UnwrapValidatedValue;

public class HttpClientConfiguration {
    @NotNull
    private Duration timeout = Duration.milliseconds((long)500L);
    @NotNull
    private Duration connectionTimeout = Duration.milliseconds((long)500L);
    @NotNull
    private Duration connectionRequestTimeout = Duration.milliseconds((long)500L);
    @NotNull
    private Duration timeToLive = Duration.hours((long)1L);
    private boolean cookiesEnabled = false;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private int maxConnections = 1024;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private int maxConnectionsPerRoute = 1024;
    @NotNull
    private Duration keepAlive = Duration.milliseconds((long)0L);
    @Min(value=0L)
    @Max(value=1000L)
    private int retries = 0;
    @NotNull
    @UnwrapValidatedValue(value=false)
    private Optional<String> userAgent = Optional.empty();
    @Valid
    @Nullable
    private ProxyConfiguration proxyConfiguration;
    @NotNull
    private Duration validateAfterInactivityPeriod = Duration.microseconds((long)0L);
    @Valid
    @Nullable
    private TlsConfiguration tlsConfiguration;

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    @JsonProperty
    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    @JsonProperty
    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    @JsonProperty
    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    @JsonProperty
    public Duration getTimeout() {
        return this.timeout;
    }

    @JsonProperty
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty
    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    @JsonProperty
    public boolean isCookiesEnabled() {
        return this.cookiesEnabled;
    }

    @JsonProperty
    public void setTimeout(Duration duration) {
        this.timeout = duration;
    }

    @JsonProperty
    public void setConnectionTimeout(Duration duration) {
        this.connectionTimeout = duration;
    }

    @JsonProperty
    public Duration getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    @JsonProperty
    public void setConnectionRequestTimeout(Duration connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    @JsonProperty
    public void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    @JsonProperty
    public void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled = enabled;
    }

    @JsonProperty
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @JsonProperty
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @JsonProperty
    public int getRetries() {
        return this.retries;
    }

    @JsonProperty
    public void setRetries(int retries) {
        this.retries = retries;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public void setUserAgent(Optional<String> userAgent) {
        this.userAgent = userAgent;
    }

    @JsonProperty(value="proxy")
    @Nullable
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @JsonProperty(value="proxy")
    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    @JsonProperty
    public Duration getValidateAfterInactivityPeriod() {
        return this.validateAfterInactivityPeriod;
    }

    @JsonProperty
    public void setValidateAfterInactivityPeriod(Duration validateAfterInactivityPeriod) {
        this.validateAfterInactivityPeriod = validateAfterInactivityPeriod;
    }

    @JsonProperty(value="tls")
    @Nullable
    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    @JsonProperty(value="tls")
    public void setTlsConfiguration(TlsConfiguration tlsConfiguration) {
        this.tlsConfiguration = tlsConfiguration;
    }
}

