/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.client.proxy.AuthConfiguration;
import io.dropwizard.validation.OneOf;
import io.dropwizard.validation.PortRange;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ProxyConfiguration {
    @NotEmpty
    private String host = "";
    @PortRange(min=-1)
    private @PortRange(min=-1) Integer port = -1;
    @OneOf(value={"http", "https"}, ignoreCase=true)
    private @OneOf(value={"http", "https"}, ignoreCase=true) String scheme = "http";
    @Valid
    @Nullable
    private AuthConfiguration auth;
    @Nullable
    private List<String> nonProxyHosts;

    public ProxyConfiguration() {
    }

    public ProxyConfiguration(@NotNull String host) {
        this.host = host;
    }

    public ProxyConfiguration(@NotNull String host, int port) {
        this(host);
        this.port = port;
    }

    public ProxyConfiguration(@NotNull String host, int port, String scheme, AuthConfiguration auth) {
        this(host, port);
        this.scheme = scheme;
        this.auth = auth;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @JsonProperty
    @Nullable
    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @JsonProperty
    public void setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    @Nullable
    public AuthConfiguration getAuth() {
        return this.auth;
    }

    public void setAuth(AuthConfiguration auth) {
        this.auth = auth;
    }
}

