/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client.ssl;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.validation.ValidationMethod;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TlsConfiguration {
    @NotEmpty
    private String protocol = "TLSv1.2";
    private @Nullable String provider;
    private @Nullable File keyStorePath;
    private @Nullable String keyStorePassword;
    @NotEmpty
    private String keyStoreType = "JKS";
    private @Nullable String keyStoreProvider;
    private @Nullable File trustStorePath;
    private @Nullable String trustStorePassword;
    @NotEmpty
    private String trustStoreType = "JKS";
    private @Nullable String trustStoreProvider;
    private boolean trustSelfSignedCertificates = false;
    private boolean verifyHostname = true;
    private @Nullable List<String> supportedProtocols = null;
    private @Nullable List<String> supportedCiphers = null;
    private @Nullable String certAlias = null;

    @JsonProperty
    public void setTrustSelfSignedCertificates(boolean trustSelfSignedCertificates) {
        this.trustSelfSignedCertificates = trustSelfSignedCertificates;
    }

    @JsonProperty
    public boolean isTrustSelfSignedCertificates() {
        return this.trustSelfSignedCertificates;
    }

    @JsonProperty
    public @Nullable File getKeyStorePath() {
        return this.keyStorePath;
    }

    @JsonProperty
    public void setKeyStorePath(File keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @JsonProperty
    public @Nullable String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @JsonProperty
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @JsonProperty
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @JsonProperty
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @JsonProperty
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @JsonProperty
    public @Nullable File getTrustStorePath() {
        return this.trustStorePath;
    }

    @JsonProperty
    public void setTrustStorePath(File trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @JsonProperty
    public @Nullable String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @JsonProperty
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @JsonProperty
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @JsonProperty
    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    @JsonProperty
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty
    public @Nullable String getProvider() {
        return this.provider;
    }

    @JsonProperty
    public void setProvider(@Nullable String provider) {
        this.provider = provider;
    }

    @JsonProperty
    public @Nullable List<String> getSupportedCiphers() {
        return this.supportedCiphers;
    }

    @JsonProperty
    public void setSupportedCiphers(@Nullable List<String> supportedCiphers) {
        this.supportedCiphers = supportedCiphers;
    }

    @JsonProperty
    public @Nullable List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @JsonProperty
    public void setSupportedProtocols(@Nullable List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @JsonProperty
    public @Nullable String getCertAlias() {
        return this.certAlias;
    }

    @JsonProperty
    public void setCertAlias(@Nullable String certAlias) {
        this.certAlias = certAlias;
    }

    @ValidationMethod(message="keyStorePassword should not be null or empty if keyStorePath not null")
    public boolean isValidKeyStorePassword() {
        return this.keyStorePath == null || this.keyStoreType.startsWith("Windows-") || Optional.ofNullable(this.keyStorePassword).filter(s -> !s.isEmpty()).isPresent();
    }

    @ValidationMethod(message="trustStorePassword should not be null or empty if trustStorePath not null")
    public boolean isValidTrustStorePassword() {
        return this.trustStorePath == null || this.trustStoreType.startsWith("Windows-") || Optional.ofNullable(this.trustStorePassword).filter(s -> !s.isEmpty()).isPresent();
    }

    public @Nullable String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(@Nullable String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public @Nullable String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public void setTrustStoreProvider(@Nullable String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }
}

