/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import io.dropwizard.configuration.EnvironmentVariableLookup;
import io.dropwizard.configuration.UndefinedEnvironmentVariableException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.matcher.StringMatcher;

public class EnvironmentVariableSubstitutor
extends StringSubstitutor {
    private final boolean strict;

    public EnvironmentVariableSubstitutor() {
        this(true, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict) {
        this(strict, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict, boolean substitutionInVariables) {
        super((StringLookup)new EnvironmentVariableLookup());
        this.strict = strict;
        this.setEnableSubstitutionInVariables(substitutionInVariables);
    }

    protected boolean substitute(TextStringBuilder buf, int offset, int length) {
        return this.substitute(buf, offset, length, null) > 0;
    }

    private void checkCyclicSubstitution(String varName, List<String> priorVariables) {
        if (!priorVariables.contains(varName)) {
            return;
        }
        TextStringBuilder buf = new TextStringBuilder(256);
        buf.append("Infinite loop in property interpolation of ");
        buf.append(priorVariables.remove(0));
        buf.append(": ");
        buf.appendWithSeparators(priorVariables, "->");
        throw new IllegalStateException(buf.toString());
    }

    private int substitute(TextStringBuilder buf, int offset, int length, @Nullable List<String> priorVariables) {
        StringMatcher pfxMatcher = this.getVariablePrefixMatcher();
        StringMatcher suffMatcher = this.getVariableSuffixMatcher();
        char escape = this.getEscapeChar();
        StringMatcher valueDelimMatcher = this.getValueDelimiterMatcher();
        boolean substitutionInVariablesEnabled = this.isEnableSubstitutionInVariables();
        boolean substitutionInValuesDisabled = this.isDisableSubstitutionInValues();
        boolean top = priorVariables == null;
        boolean altered = false;
        int lengthChange = 0;
        char[] chars = buf.toCharArray();
        int bufEnd = offset + length;
        int pos = offset;
        block0: while (pos < bufEnd) {
            int startMatchLen = pfxMatcher.isMatch(chars, pos, offset, bufEnd);
            if (startMatchLen == 0) {
                ++pos;
                continue;
            }
            if (pos > offset && chars[pos - 1] == escape) {
                if (this.isPreserveEscapes()) {
                    ++pos;
                    continue;
                }
                buf.deleteCharAt(pos - 1);
                chars = buf.toCharArray();
                --lengthChange;
                altered = true;
                --bufEnd;
                continue;
            }
            int startPos = pos;
            pos += startMatchLen;
            int endMatchLen = 0;
            int nestedVarCount = 0;
            while (pos < bufEnd) {
                if (substitutionInVariablesEnabled && pfxMatcher.isMatch(chars, pos, offset, bufEnd) != 0) {
                    endMatchLen = pfxMatcher.isMatch(chars, pos, offset, bufEnd);
                    ++nestedVarCount;
                    pos += endMatchLen;
                    continue;
                }
                endMatchLen = suffMatcher.isMatch(chars, pos, offset, bufEnd);
                if (endMatchLen == 0) {
                    ++pos;
                    continue;
                }
                if (nestedVarCount == 0) {
                    String varNameExpr = new String(chars, startPos + startMatchLen, pos - startPos - startMatchLen);
                    if (substitutionInVariablesEnabled) {
                        TextStringBuilder bufName = new TextStringBuilder(varNameExpr);
                        this.substitute(bufName, 0, bufName.length());
                        varNameExpr = bufName.toString();
                    }
                    int endPos = pos += endMatchLen;
                    String varName = varNameExpr;
                    String varDefaultValue = null;
                    if (valueDelimMatcher != null) {
                        char[] varNameExprChars = varNameExpr.toCharArray();
                        int valueDelimiterMatchLen = 0;
                        for (int i = 0; i < varNameExprChars.length && (substitutionInVariablesEnabled || pfxMatcher.isMatch(varNameExprChars, i, i, varNameExprChars.length) == 0); ++i) {
                            if (valueDelimMatcher.isMatch(varNameExprChars, i, 0, varNameExprChars.length) == 0) continue;
                            valueDelimiterMatchLen = valueDelimMatcher.isMatch(varNameExprChars, i, 0, varNameExprChars.length);
                            varName = varNameExpr.substring(0, i);
                            varDefaultValue = varNameExpr.substring(i + valueDelimiterMatchLen);
                            break;
                        }
                    }
                    if (priorVariables == null) {
                        priorVariables = new ArrayList<String>();
                        priorVariables.add(new String(chars, offset, length + lengthChange));
                    }
                    this.checkCyclicSubstitution(varName, priorVariables);
                    priorVariables.add(varName);
                    String varValue = this.resolveVariable(varName, buf, startPos, endPos);
                    if (varValue == null) {
                        varValue = varDefaultValue;
                    }
                    if (varValue != null) {
                        int varLen = varValue.length();
                        buf.replace(startPos, endPos, varValue);
                        altered = true;
                        int change = 0;
                        if (!substitutionInValuesDisabled) {
                            change = this.substitute(buf, startPos, varLen, priorVariables);
                        }
                        change = change + varLen - (endPos - startPos);
                        pos += change;
                        bufEnd += change;
                        lengthChange += change;
                        chars = buf.toCharArray();
                    } else if (this.strict) {
                        throw new UndefinedEnvironmentVariableException("The environment variable '" + varName + "' is not defined; could not substitute the expression '${" + varName + "}'.");
                    }
                    priorVariables.remove(priorVariables.size() - 1);
                    continue block0;
                }
                --nestedVarCount;
                pos += endMatchLen;
            }
        }
        if (top) {
            return altered ? 1 : 0;
        }
        return lengthChange;
    }
}

