/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationMetadata;
import io.dropwizard.configuration.ConfigurationParsingException;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.ConfigurationValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Validator;

public abstract class BaseConfigurationFactory<T>
implements ConfigurationFactory<T> {
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\\\,");
    private static final Pattern ESCAPED_COMMA_SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_DOT_PATTERN = Pattern.compile("\\\\\\.");
    private static final Pattern ESCAPED_DOT_SPLIT_PATTERN = Pattern.compile("(?<!\\\\)\\.");
    private final Class<T> klass;
    private final String propertyPrefix;
    protected final ObjectMapper mapper;
    private final ConfigurationMetadata configurationMetadata;
    @Nullable
    private final Validator validator;
    private final String formatName;
    private final JsonFactory parserFactory;

    public BaseConfigurationFactory(JsonFactory parserFactory, String formatName, Class<T> klass, @Nullable Validator validator, ObjectMapper objectMapper, String propertyPrefix) {
        this.klass = klass;
        this.formatName = formatName;
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + '.';
        this.mapper = objectMapper;
        this.parserFactory = parserFactory;
        this.validator = validator;
        this.configurationMetadata = new ConfigurationMetadata(this.mapper, klass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
        try (InputStream input = provider.open(Objects.requireNonNull(path));){
            JsonNode node = (JsonNode)this.mapper.readTree(this.createParser(input));
            if (node == null) {
                throw ConfigurationParsingException.builder("Configuration at " + path + " must not be empty").build(path);
            }
            T t = this.build(node, path);
            return t;
        }
        catch (JsonParseException e) {
            throw ConfigurationParsingException.builder("Malformed " + this.formatName).setCause((Exception)((Object)e)).setLocation(e.getLocation()).setDetail(e.getMessage()).build(path);
        }
    }

    protected JsonParser createParser(InputStream input) throws IOException {
        return this.parserFactory.createParser(input);
    }

    @Override
    public T build() throws IOException, ConfigurationException {
        try {
            T instance = this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JsonNode node = this.mapper.valueToTree(instance);
            return this.build(node, "default configuration");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create an instance of the configuration class: '" + this.klass.getCanonicalName() + "'", e);
        }
    }

    protected T build(JsonNode node, String path) throws IOException, ConfigurationException {
        for (Map.Entry<Object, Object> pref : System.getProperties().entrySet()) {
            String prefName = (String)pref.getKey();
            if (!prefName.startsWith(this.propertyPrefix)) continue;
            String configName = prefName.substring(this.propertyPrefix.length());
            this.addOverride(node, configName, System.getProperty(prefName));
        }
        try {
            Object config = this.mapper.readValue((JsonParser)new TreeTraversingParser(node), this.klass);
            this.validate(path, config);
            return (T)config;
        }
        catch (UnrecognizedPropertyException e) {
            List<String> properties = e.getKnownPropertyIds().stream().map(Object::toString).collect(Collectors.toList());
            throw ConfigurationParsingException.builder("Unrecognized field").setFieldPath(e.getPath()).setLocation(e.getLocation()).addSuggestions(properties).setSuggestionBase(e.getPropertyName()).setCause((Exception)((Object)e)).build(path);
        }
        catch (InvalidFormatException e) {
            String sourceType = e.getValue().getClass().getSimpleName();
            String targetType = e.getTargetType().getSimpleName();
            throw ConfigurationParsingException.builder("Incorrect type of value").setDetail("is of type: " + sourceType + ", expected: " + targetType).setLocation(e.getLocation()).setFieldPath(e.getPath()).setCause((Exception)((Object)e)).build(path);
        }
        catch (JsonMappingException e) {
            throw ConfigurationParsingException.builder("Failed to parse configuration").setDetail(e.getMessage()).setFieldPath(e.getPath()).setLocation(e.getLocation()).setCause((Exception)((Object)e)).build(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addOverride(JsonNode root, String name, String value) {
        JsonNode node = root;
        List parts = Arrays.stream(ESCAPED_DOT_SPLIT_PATTERN.split(name)).map(String::trim).map(key -> ESCAPED_DOT_PATTERN.matcher((CharSequence)key).replaceAll(".")).collect(Collectors.toList());
        int i = 0;
        while (i < parts.size()) {
            JsonNode child;
            boolean moreParts;
            String key2 = (String)parts.get(i);
            if (!(node instanceof ObjectNode)) {
                throw new IllegalArgumentException("Unable to override " + name + "; it's not a valid path.");
            }
            ObjectNode obj = (ObjectNode)node;
            String remainingPath = parts.subList(i, parts.size()).stream().collect(Collectors.joining("."));
            if (obj.has(remainingPath) && !remainingPath.equals(key2) && obj.get(remainingPath).isValueNode()) {
                obj.put(remainingPath, value);
                return;
            }
            boolean bl = moreParts = i < parts.size() - 1;
            if (key2.matches(".+\\[\\d+\\]$")) {
                int s = key2.indexOf(91);
                int index = Integer.parseInt(key2.substring(s + 1, key2.length() - 1));
                child = obj.get(key2.substring(0, s));
                if (child == null) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index not found.");
                }
                if (!child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index is not an array.");
                }
                if (index >= child.size()) {
                    throw new ArrayIndexOutOfBoundsException("Unable to override " + name + "; index is greater than size of array.");
                }
                if (!moreParts) {
                    ArrayNode array = (ArrayNode)child;
                    array.set(index, (JsonNode)TextNode.valueOf((String)value));
                    return;
                }
                node = child = child.get(index);
            } else if (moreParts) {
                child = obj.get(key2);
                if (child == null) {
                    child = obj.objectNode();
                    obj.set(key2, child);
                }
                if (child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; target is an array but no index specified");
                }
                node = child;
            }
            if (!moreParts) {
                if (node.get(key2) != null && node.get(key2).isArray() || node.get(key2) == null && this.configurationMetadata.isCollectionOfStrings(name)) {
                    ArrayNode arrayNode = (ArrayNode)obj.get(key2);
                    if (arrayNode == null) {
                        arrayNode = obj.arrayNode();
                        obj.set(key2, (JsonNode)arrayNode);
                    }
                    arrayNode.removeAll();
                    Arrays.stream(ESCAPED_COMMA_SPLIT_PATTERN.split(value)).map(String::trim).map(val -> ESCAPED_COMMA_PATTERN.matcher((CharSequence)val).replaceAll(",")).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else {
                    obj.put(key2, value);
                }
            }
            ++i;
        }
        return;
    }

    private void validate(String path, T config) throws ConfigurationValidationException {
        Set violations;
        if (this.validator != null && !(violations = this.validator.validate(config, new Class[0])).isEmpty()) {
            throw new ConfigurationValidationException(path, violations);
        }
    }
}

