/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import io.dropwizard.configuration.EnvironmentVariableLookup;
import io.dropwizard.configuration.UndefinedEnvironmentVariableException;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;

public class EnvironmentVariableSubstitutor
extends StringSubstitutor {
    public EnvironmentVariableSubstitutor() {
        this(true, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict) {
        this(strict, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict, boolean substitutionInVariables) {
        super((StringLookup)new EnvironmentVariableLookup());
        this.setEnableUndefinedVariableException(strict);
        this.setEnableSubstitutionInVariables(substitutionInVariables);
    }

    protected boolean substitute(TextStringBuilder buf, int offset, int length) {
        try {
            return super.substitute(buf, offset, length);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains("Cannot resolve variable")) {
                throw new UndefinedEnvironmentVariableException(e.getMessage());
            }
            throw e;
        }
    }
}

