/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import java.util.Collection;

public abstract class ConfigurationException
extends Exception {
    private static final long serialVersionUID = 7596147083618606385L;
    protected static final String NEWLINE = String.format("%n", new Object[0]);
    private final Collection<String> errors;

    protected ConfigurationException(String path, Collection<String> errors) {
        super(ConfigurationException.formatMessage(path, errors));
        this.errors = errors;
    }

    protected ConfigurationException(String path, Collection<String> errors, Throwable cause) {
        super(ConfigurationException.formatMessage(path, errors), cause);
        this.errors = errors;
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    protected static String formatMessage(String file, Collection<String> errors) {
        StringBuilder msg = new StringBuilder(file);
        msg.append(errors.size() == 1 ? " has an error:" : " has the following errors:").append(NEWLINE);
        for (String error : errors) {
            msg.append("  * ").append(error).append(NEWLINE);
        }
        return msg.toString();
    }
}

