/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.ContextRoutingHandler;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.server.AbstractServerFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Maps;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="simple")
public class SimpleServerFactory
extends AbstractServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleServerFactory.class);
    @Valid
    @NotNull
    private ConnectorFactory connector = HttpConnectorFactory.application();
    @NotEmpty
    private String applicationContextPath = "/application";
    @NotEmpty
    private String adminContextPath = "/admin";

    @JsonProperty
    public ConnectorFactory getConnector() {
        return this.connector;
    }

    @JsonProperty
    public void setConnector(ConnectorFactory factory) {
        this.connector = factory;
    }

    @JsonProperty
    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    @JsonProperty
    public void setApplicationContextPath(String contextPath) {
        this.applicationContextPath = contextPath;
    }

    @JsonProperty
    public String getAdminContextPath() {
        return this.adminContextPath;
    }

    @JsonProperty
    public void setAdminContextPath(String contextPath) {
        this.adminContextPath = contextPath;
    }

    @Override
    public Server build(Environment environment) {
        this.configure(environment);
        this.printBanner(environment.getName());
        ThreadPool threadPool = this.createThreadPool(environment.metrics());
        Server server = this.buildServer(environment.lifecycle(), threadPool);
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        Handler adminHandler = this.createAdminServlet(server, environment.getAdminContext(), environment.metrics(), environment.healthChecks(), environment.admin());
        Connector conn = this.connector.build(server, environment.metrics(), environment.getName(), null);
        server.addConnector(conn);
        Map handlers = Maps.of((Object)this.applicationContextPath, (Object)applicationHandler, (Object)this.adminContextPath, (Object)adminHandler);
        ContextRoutingHandler routingHandler = new ContextRoutingHandler(handlers);
        Handler gzipHandler = this.buildGzipHandler((Handler)routingHandler);
        server.setHandler(this.addStatsHandler(this.addRequestLog(server, gzipHandler, environment.getName())));
        return server;
    }

    @Override
    public void configure(Environment environment) {
        LOGGER.info("Registering jersey handler with root path prefix: {}", (Object)this.applicationContextPath);
        environment.getApplicationContext().setContextPath(this.applicationContextPath);
        LOGGER.info("Registering admin handler with root path prefix: {}", (Object)this.adminContextPath);
        environment.getAdminContext().setContextPath(this.adminContextPath);
    }
}

