/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.server;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.core.server.AbstractServerFactory;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.jetty.RoutingHandler;
import io.dropwizard.metrics.jetty12.InstrumentedQueuedThreadPool;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="default")
public class DefaultServerFactory
extends AbstractServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerFactory.class);
    @Valid
    @NotNull
    private List<ConnectorFactory> applicationConnectors = Collections.singletonList(HttpConnectorFactory.application());
    @Valid
    @NotNull
    private List<ConnectorFactory> adminConnectors = Collections.singletonList(HttpConnectorFactory.admin());
    @Min(value=4L)
    private @Min(value=4L) int adminMaxThreads = 64;
    @Min(value=1L)
    private @Min(value=1L) int adminMinThreads = 1;
    private boolean enableAdminVirtualThreads;
    @NotEmpty
    private String applicationContextPath = "/";
    @NotEmpty
    private String adminContextPath = "/";

    @JsonProperty
    public List<ConnectorFactory> getApplicationConnectors() {
        return this.applicationConnectors;
    }

    @JsonProperty
    public void setApplicationConnectors(List<ConnectorFactory> connectors) {
        this.applicationConnectors = connectors;
    }

    @JsonProperty
    public List<ConnectorFactory> getAdminConnectors() {
        return this.adminConnectors;
    }

    @JsonProperty
    public void setAdminConnectors(List<ConnectorFactory> connectors) {
        this.adminConnectors = connectors;
    }

    @JsonProperty
    public int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    @JsonProperty
    public void setAdminMaxThreads(int adminMaxThreads) {
        this.adminMaxThreads = adminMaxThreads;
    }

    @JsonProperty
    public int getAdminMinThreads() {
        return this.adminMinThreads;
    }

    @JsonProperty
    public void setAdminMinThreads(int adminMinThreads) {
        this.adminMinThreads = adminMinThreads;
    }

    @JsonProperty
    public boolean isEnableAdminVirtualThreads() {
        return this.enableAdminVirtualThreads;
    }

    @JsonProperty
    public void setEnableAdminVirtualThreads(boolean enableAdminVirtualThreads) {
        this.enableAdminVirtualThreads = enableAdminVirtualThreads;
    }

    @JsonProperty
    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    @JsonProperty
    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }

    @JsonProperty
    public String getAdminContextPath() {
        return this.adminContextPath;
    }

    @JsonProperty
    public void setAdminContextPath(String adminContextPath) {
        this.adminContextPath = adminContextPath;
    }

    @Override
    public Server build(Environment environment) {
        this.printBanner(environment.getName());
        ThreadPool threadPool = this.createThreadPool(environment.metrics());
        Server server = this.buildServer(environment.lifecycle(), threadPool);
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        Handler adminHandler = this.createAdminServlet(server, environment.getAdminContext(), environment.metrics(), environment.healthChecks(), environment.admin());
        RoutingHandler routingHandler = this.buildRoutingHandler(environment.metrics(), server, applicationHandler, adminHandler);
        Handler gzipHandler = this.buildGzipHandler((Handler)routingHandler);
        server.setHandler(this.addGracefulHandler(gzipHandler));
        this.addRequestLog(server, environment.getName(), environment.getApplicationContext());
        return server;
    }

    @Override
    public void configure(Environment environment) {
        LOGGER.info("Registering jersey handler with root path prefix: {}", (Object)this.applicationContextPath);
        environment.getApplicationContext().setContextPath(this.applicationContextPath);
        LOGGER.info("Registering admin handler with root path prefix: {}", (Object)this.adminContextPath);
        environment.getAdminContext().setContextPath(this.adminContextPath);
    }

    private RoutingHandler buildRoutingHandler(MetricRegistry metricRegistry, Server server, Handler applicationHandler, Handler adminHandler) {
        List<Connector> appConnectors = this.buildAppConnectors(metricRegistry, server);
        List<Connector> adConnectors = this.buildAdminConnectors(metricRegistry, server);
        LinkedHashMap<Connector, Handler> handlers = new LinkedHashMap<Connector, Handler>();
        for (Connector connector : appConnectors) {
            server.addConnector(connector);
            handlers.put(connector, applicationHandler);
        }
        for (Connector connector : adConnectors) {
            server.addConnector(connector);
            handlers.put(connector, adminHandler);
        }
        return new RoutingHandler(handlers);
    }

    private List<Connector> buildAdminConnectors(MetricRegistry metricRegistry, Server server) {
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, this.adminMaxThreads, this.adminMinThreads);
        if (this.enableAdminVirtualThreads) {
            threadPool.setVirtualThreadsExecutor((Executor)this.getVirtualThreadsExecutorService());
        }
        threadPool.setName("dw-admin");
        server.addBean((Object)threadPool);
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (ConnectorFactory factory : this.adminConnectors) {
            Connector connector = factory.build(server, metricRegistry, "admin", (ThreadPool)threadPool);
            if (connector instanceof ContainerLifeCycle) {
                connector.unmanage((Object)threadPool);
            }
            connectors.add(connector);
        }
        return connectors;
    }

    private List<Connector> buildAppConnectors(MetricRegistry metricRegistry, Server server) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (ConnectorFactory factory : this.applicationConnectors) {
            connectors.add(factory.build(server, metricRegistry, "application", null));
        }
        return connectors;
    }

    public String toString() {
        return "DefaultServerFactory{applicationConnectors=" + String.valueOf(this.applicationConnectors) + ", adminConnectors=" + String.valueOf(this.adminConnectors) + ", adminMaxThreads=" + this.adminMaxThreads + ", adminMinThreads=" + this.adminMinThreads + ", applicationContextPath='" + this.applicationContextPath + "', adminContextPath='" + this.adminContextPath + "'}";
    }
}

