/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.db;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.ManagedPooledDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.ValidationMethod;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class DataSourceFactory
implements PooledDataSourceFactory {
    private static final String DEFAULT_VALIDATION_QUERY = "/* Health Check */ SELECT 1";
    @Nullable
    private String driverClass;
    @Min(value=0L)
    @Max(value=100L)
    private @Min(value=0L) @Max(value=100L) int abandonWhenPercentageFull = 0;
    private boolean alternateUsernamesAllowed = false;
    private boolean commitOnReturn = false;
    private boolean rollbackOnReturn = false;
    @Nullable
    private Boolean autoCommitByDefault;
    @Nullable
    private Boolean readOnlyByDefault;
    @Nullable
    private String user;
    @Nullable
    private String password;
    @NotEmpty
    private String url = "";
    @NotNull
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    @Nullable
    private String defaultCatalog;
    @NotNull
    private TransactionIsolation defaultTransactionIsolation = TransactionIsolation.DEFAULT;
    private boolean useFairQueue = true;
    @Min(value=0L)
    private @Min(value=0L) int initialSize = 10;
    @Min(value=0L)
    private @Min(value=0L) int minSize = 10;
    @Min(value=1L)
    private @Min(value=1L) int maxSize = 100;
    @Nullable
    private String initializationQuery;
    private boolean logAbandonedConnections = false;
    private boolean logValidationErrors = false;
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    @Nullable
    private @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration maxConnectionAge;
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration maxWaitForConnection = Duration.seconds((long)30L);
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration minIdleTime = Duration.minutes((long)1L);
    private Optional<String> validationQuery = Optional.of("/* Health Check */ SELECT 1");
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    @Nullable
    private @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration validationQueryTimeout;
    private boolean checkConnectionWhileIdle = true;
    private boolean checkConnectionOnBorrow = false;
    private boolean checkConnectionOnConnect = true;
    private boolean checkConnectionOnReturn = false;
    private boolean autoCommentsEnabled = true;
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration evictionInterval = Duration.seconds((long)5L);
    @NotNull
    @MinDuration(value=50L, unit=TimeUnit.MILLISECONDS)
    private @NotNull @MinDuration(value=50L, unit=TimeUnit.MILLISECONDS) Duration validationInterval = Duration.seconds((long)30L);
    private Optional<String> validatorClassName = Optional.empty();
    private boolean removeAbandoned = false;
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration removeAbandonedTimeout = Duration.seconds((long)60L);
    private Optional<String> jdbcInterceptors = Optional.empty();
    private boolean ignoreExceptionOnPreLoad = false;

    @Override
    @JsonProperty
    public boolean isAutoCommentsEnabled() {
        return this.autoCommentsEnabled;
    }

    @JsonProperty
    public void setAutoCommentsEnabled(boolean autoCommentsEnabled) {
        this.autoCommentsEnabled = autoCommentsEnabled;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getDriverClass() {
        return this.driverClass;
    }

    @JsonProperty
    public void setDriverClass(@Nullable String driverClass) {
        this.driverClass = driverClass;
    }

    @JsonProperty
    @Nullable
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public void setUser(@Nullable String user) {
        this.user = user;
    }

    @JsonProperty
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty
    public Duration getMaxWaitForConnection() {
        return this.maxWaitForConnection;
    }

    @JsonProperty
    public void setMaxWaitForConnection(Duration maxWaitForConnection) {
        this.maxWaitForConnection = maxWaitForConnection;
    }

    @Override
    @JsonProperty
    public Optional<String> getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    @Deprecated
    @JsonIgnore
    public String getHealthCheckValidationQuery() {
        return this.getValidationQuery().orElse(DEFAULT_VALIDATION_QUERY);
    }

    @JsonProperty
    public void setValidationQuery(@Nullable String validationQuery) {
        this.validationQuery = Optional.ofNullable(validationQuery);
    }

    @JsonProperty
    public int getMinSize() {
        return this.minSize;
    }

    @JsonProperty
    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @JsonProperty
    public int getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @JsonProperty
    public boolean getCheckConnectionWhileIdle() {
        return this.checkConnectionWhileIdle;
    }

    @JsonProperty
    public void setCheckConnectionWhileIdle(boolean checkConnectionWhileIdle) {
        this.checkConnectionWhileIdle = checkConnectionWhileIdle;
    }

    @Deprecated
    @JsonProperty
    public boolean isDefaultReadOnly() {
        return Boolean.TRUE.equals(this.readOnlyByDefault);
    }

    @Deprecated
    @JsonProperty
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.readOnlyByDefault = defaultReadOnly;
    }

    @JsonIgnore
    @ValidationMethod(message=".minSize must be less than or equal to maxSize")
    public boolean isMinSizeLessThanMaxSize() {
        return this.minSize <= this.maxSize;
    }

    @JsonIgnore
    @ValidationMethod(message=".initialSize must be less than or equal to maxSize")
    public boolean isInitialSizeLessThanMaxSize() {
        return this.initialSize <= this.maxSize;
    }

    @JsonIgnore
    @ValidationMethod(message=".initialSize must be greater than or equal to minSize")
    public boolean isInitialSizeGreaterThanMinSize() {
        return this.minSize <= this.initialSize;
    }

    @JsonProperty
    public int getAbandonWhenPercentageFull() {
        return this.abandonWhenPercentageFull;
    }

    @JsonProperty
    public void setAbandonWhenPercentageFull(int percentage) {
        this.abandonWhenPercentageFull = percentage;
    }

    @JsonProperty
    public boolean isAlternateUsernamesAllowed() {
        return this.alternateUsernamesAllowed;
    }

    @JsonProperty
    public void setAlternateUsernamesAllowed(boolean allow) {
        this.alternateUsernamesAllowed = allow;
    }

    @JsonProperty
    public boolean getCommitOnReturn() {
        return this.commitOnReturn;
    }

    @JsonProperty
    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    @JsonProperty
    public void setCommitOnReturn(boolean commitOnReturn) {
        this.commitOnReturn = commitOnReturn;
    }

    @JsonProperty
    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    @JsonProperty
    @Nullable
    public Boolean getAutoCommitByDefault() {
        return this.autoCommitByDefault;
    }

    @JsonProperty
    public void setAutoCommitByDefault(@Nullable Boolean autoCommit) {
        this.autoCommitByDefault = autoCommit;
    }

    @JsonProperty
    @Nullable
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @JsonProperty
    public void setDefaultCatalog(@Nullable String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    @JsonProperty
    @Nullable
    public Boolean getReadOnlyByDefault() {
        return this.readOnlyByDefault;
    }

    @JsonProperty
    public void setReadOnlyByDefault(@Nullable Boolean readOnlyByDefault) {
        this.readOnlyByDefault = readOnlyByDefault;
    }

    @JsonProperty
    public TransactionIsolation getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @JsonProperty
    public void setDefaultTransactionIsolation(TransactionIsolation isolation) {
        this.defaultTransactionIsolation = isolation;
    }

    @JsonProperty
    public boolean getUseFairQueue() {
        return this.useFairQueue;
    }

    @JsonProperty
    public void setUseFairQueue(boolean fair) {
        this.useFairQueue = fair;
    }

    @JsonProperty
    public int getInitialSize() {
        return this.initialSize;
    }

    @JsonProperty
    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    @JsonProperty
    @Nullable
    public String getInitializationQuery() {
        return this.initializationQuery;
    }

    @JsonProperty
    public void setInitializationQuery(@Nullable String query) {
        this.initializationQuery = query;
    }

    @JsonProperty
    public boolean getLogAbandonedConnections() {
        return this.logAbandonedConnections;
    }

    @JsonProperty
    public void setLogAbandonedConnections(boolean log) {
        this.logAbandonedConnections = log;
    }

    @JsonProperty
    public boolean getLogValidationErrors() {
        return this.logValidationErrors;
    }

    @JsonProperty
    public void setLogValidationErrors(boolean log) {
        this.logValidationErrors = log;
    }

    @JsonProperty
    public Optional<Duration> getMaxConnectionAge() {
        return Optional.ofNullable(this.maxConnectionAge);
    }

    @JsonProperty
    public void setMaxConnectionAge(@Nullable Duration age) {
        this.maxConnectionAge = age;
    }

    @JsonProperty
    public Duration getMinIdleTime() {
        return this.minIdleTime;
    }

    @JsonProperty
    public void setMinIdleTime(Duration time) {
        this.minIdleTime = time;
    }

    @JsonProperty
    public boolean getCheckConnectionOnBorrow() {
        return this.checkConnectionOnBorrow;
    }

    @JsonProperty
    public void setCheckConnectionOnBorrow(boolean checkConnectionOnBorrow) {
        this.checkConnectionOnBorrow = checkConnectionOnBorrow;
    }

    @JsonProperty
    public boolean getCheckConnectionOnConnect() {
        return this.checkConnectionOnConnect;
    }

    @JsonProperty
    public void setCheckConnectionOnConnect(boolean checkConnectionOnConnect) {
        this.checkConnectionOnConnect = checkConnectionOnConnect;
    }

    @JsonProperty
    public boolean getCheckConnectionOnReturn() {
        return this.checkConnectionOnReturn;
    }

    @JsonProperty
    public void setCheckConnectionOnReturn(boolean checkConnectionOnReturn) {
        this.checkConnectionOnReturn = checkConnectionOnReturn;
    }

    @JsonProperty
    public Duration getEvictionInterval() {
        return this.evictionInterval;
    }

    @JsonProperty
    public void setEvictionInterval(Duration interval) {
        this.evictionInterval = interval;
    }

    @JsonProperty
    public Duration getValidationInterval() {
        return this.validationInterval;
    }

    @JsonProperty
    public void setValidationInterval(Duration validationInterval) {
        this.validationInterval = validationInterval;
    }

    @Override
    @JsonProperty
    public Optional<Duration> getValidationQueryTimeout() {
        return Optional.ofNullable(this.validationQueryTimeout);
    }

    @JsonProperty
    public Optional<String> getValidatorClassName() {
        return this.validatorClassName;
    }

    @JsonProperty
    public void setValidatorClassName(Optional<String> validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    @Override
    @Deprecated
    @JsonIgnore
    public Optional<Duration> getHealthCheckValidationTimeout() {
        return this.getValidationQueryTimeout();
    }

    @JsonProperty
    public void setValidationQueryTimeout(@Nullable Duration validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    @JsonProperty
    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    @JsonProperty
    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @JsonProperty
    public Duration getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    @JsonProperty
    public void setRemoveAbandonedTimeout(Duration removeAbandonedTimeout) {
        this.removeAbandonedTimeout = Objects.requireNonNull(removeAbandonedTimeout);
    }

    @JsonProperty
    public Optional<String> getJdbcInterceptors() {
        return this.jdbcInterceptors;
    }

    @JsonProperty
    public void setJdbcInterceptors(Optional<String> jdbcInterceptors) {
        this.jdbcInterceptors = jdbcInterceptors;
    }

    @JsonProperty
    public boolean isIgnoreExceptionOnPreLoad() {
        return this.ignoreExceptionOnPreLoad;
    }

    @JsonProperty
    public void setIgnoreExceptionOnPreLoad(boolean ignoreExceptionOnPreLoad) {
        this.ignoreExceptionOnPreLoad = ignoreExceptionOnPreLoad;
    }

    @Override
    public void asSingleConnectionPool() {
        this.minSize = 1;
        this.maxSize = 1;
        this.initialSize = 1;
    }

    @Override
    public ManagedDataSource build(MetricRegistry metricRegistry, String name) {
        Properties dbProperties = new Properties();
        this.properties.forEach(dbProperties::setProperty);
        PoolProperties poolConfig = new PoolProperties();
        poolConfig.setAbandonWhenPercentageFull(this.abandonWhenPercentageFull);
        poolConfig.setAlternateUsernameAllowed(this.alternateUsernamesAllowed);
        poolConfig.setCommitOnReturn(this.commitOnReturn);
        poolConfig.setRollbackOnReturn(this.rollbackOnReturn);
        poolConfig.setDbProperties(dbProperties);
        poolConfig.setDefaultAutoCommit(this.autoCommitByDefault);
        poolConfig.setDefaultCatalog(this.defaultCatalog);
        poolConfig.setDefaultReadOnly(this.readOnlyByDefault);
        poolConfig.setDefaultTransactionIsolation(this.defaultTransactionIsolation.get());
        poolConfig.setDriverClassName(this.driverClass);
        poolConfig.setFairQueue(this.useFairQueue);
        poolConfig.setIgnoreExceptionOnPreLoad(this.ignoreExceptionOnPreLoad);
        poolConfig.setInitialSize(this.initialSize);
        poolConfig.setInitSQL(this.initializationQuery);
        poolConfig.setLogAbandoned(this.logAbandonedConnections);
        poolConfig.setLogValidationErrors(this.logValidationErrors);
        poolConfig.setMaxActive(this.maxSize);
        poolConfig.setMaxIdle(this.maxSize);
        poolConfig.setMinIdle(this.minSize);
        this.getMaxConnectionAge().map(Duration::toMilliseconds).ifPresent(arg_0 -> ((PoolProperties)poolConfig).setMaxAge(arg_0));
        poolConfig.setMaxWait((int)this.maxWaitForConnection.toMilliseconds());
        poolConfig.setMinEvictableIdleTimeMillis((int)this.minIdleTime.toMilliseconds());
        poolConfig.setName(name);
        poolConfig.setUrl(this.url);
        poolConfig.setUsername(this.user);
        poolConfig.setPassword(this.user != null && this.password == null ? "" : this.password);
        poolConfig.setRemoveAbandoned(this.removeAbandoned);
        poolConfig.setRemoveAbandonedTimeout((int)this.removeAbandonedTimeout.toSeconds());
        poolConfig.setTestWhileIdle(this.checkConnectionWhileIdle);
        this.validationQuery.ifPresent(arg_0 -> ((PoolProperties)poolConfig).setValidationQuery(arg_0));
        poolConfig.setTestOnBorrow(this.checkConnectionOnBorrow);
        poolConfig.setTestOnConnect(this.checkConnectionOnConnect);
        poolConfig.setTestOnReturn(this.checkConnectionOnReturn);
        poolConfig.setTimeBetweenEvictionRunsMillis((int)this.evictionInterval.toMilliseconds());
        poolConfig.setValidationInterval(this.validationInterval.toMilliseconds());
        this.getValidationQueryTimeout().map(x -> (int)x.toSeconds()).ifPresent(arg_0 -> ((PoolProperties)poolConfig).setValidationQueryTimeout(arg_0));
        this.validatorClassName.ifPresent(arg_0 -> ((PoolProperties)poolConfig).setValidatorClassName(arg_0));
        this.jdbcInterceptors.ifPresent(arg_0 -> ((PoolProperties)poolConfig).setJdbcInterceptors(arg_0));
        return new ManagedPooledDataSource((PoolConfiguration)poolConfig, metricRegistry);
    }

    public static enum TransactionIsolation {
        NONE(0),
        DEFAULT(-1),
        READ_UNCOMMITTED(1),
        READ_COMMITTED(2),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private final int value;

        private TransactionIsolation(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }
    }
}

