/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.check.http;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import io.dropwizard.health.check.http.HttpHealthResponse;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHealthCheck
extends HealthCheck {
    static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(2L);
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHealthCheck.class);
    @Nonnull
    private final String url;
    @Nonnull
    private final Client client;

    public HttpHealthCheck(@Nonnull String url) {
        this(url, DEFAULT_TIMEOUT, DEFAULT_TIMEOUT);
    }

    public HttpHealthCheck(@Nonnull String url, Duration readTimeout, Duration connectionTimeout) {
        this.url = Objects.requireNonNull(url);
        Preconditions.checkState((readTimeout.toMillis() > 0L ? 1 : 0) != 0);
        Preconditions.checkState((connectionTimeout.toMillis() > 0L ? 1 : 0) != 0);
        this.client = (Client)((Client)ClientBuilder.newClient().property("jersey.config.client.connectTimeout", (Object)((int)connectionTimeout.toMillis()))).property("jersey.config.client.readTimeout", (Object)((int)readTimeout.toMillis()));
    }

    public HttpHealthCheck(@Nonnull String url, @Nonnull Client client) {
        this.url = Objects.requireNonNull(url);
        this.client = Objects.requireNonNull(client);
    }

    protected HealthCheck.Result check() {
        HttpHealthResponse httpHealthResponse = this.httpCheck(this.url);
        if (this.isHealthResponseValid(httpHealthResponse)) {
            LOGGER.debug("Health check against url={} successful", (Object)this.url);
            return HealthCheck.Result.healthy();
        }
        LOGGER.debug("Health check against url={} failed with response={}", (Object)this.url, (Object)httpHealthResponse);
        return HealthCheck.Result.unhealthy((String)"Http health check against url=%s failed with response=%s", (Object[])new Object[]{this.url, httpHealthResponse});
    }

    protected HttpHealthResponse httpCheck(String url) {
        Response response = this.client.target(url).request().get();
        String entityString = (String)response.readEntity(String.class);
        return new HttpHealthResponse(response.getStatus(), entityString);
    }

    protected boolean isHealthResponseValid(HttpHealthResponse httpHealthResponse) {
        Response.Status.Family statusFamily = Response.Status.Family.familyOf((int)httpHealthResponse.getStatus());
        return statusFamily == Response.Status.Family.SUCCESSFUL;
    }
}

