/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import io.dropwizard.health.response.HealthResponse;
import io.dropwizard.health.response.HealthResponseProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletHealthResponder
extends HttpServlet {
    private final HealthResponseProvider healthResponseProvider;
    private final boolean cacheControlEnabled;
    private final String cacheControlValue;

    public ServletHealthResponder(HealthResponseProvider healthResponseProvider, boolean cacheControlEnabled, String cacheControlValue) {
        this.healthResponseProvider = Objects.requireNonNull(healthResponseProvider);
        this.cacheControlEnabled = cacheControlEnabled;
        this.cacheControlValue = Objects.requireNonNull(cacheControlValue);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.cacheControlEnabled) {
            response.setHeader("Cache-Control", this.cacheControlValue);
        }
        Map<String, Collection<String>> queryParameters = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((String[])entry.getValue())));
        HealthResponse healthResponse = this.healthResponseProvider.healthResponse(queryParameters);
        response.setContentType(healthResponse.getContentType());
        response.getWriter().write(healthResponse.getMessage());
        response.setStatus(healthResponse.getStatus());
    }
}

