/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.check.http;

import java.util.Objects;
import javax.annotation.Nonnull;

public class HttpHealthResponse {
    private final int status;
    @Nonnull
    private final String body;

    public HttpHealthResponse(int status, @Nonnull String body) {
        this.status = status;
        this.body = Objects.requireNonNull(body);
    }

    public int getStatus() {
        return this.status;
    }

    @Nonnull
    public String getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHealthResponse)) {
            return false;
        }
        HttpHealthResponse that = (HttpHealthResponse)other;
        return this.status == that.status && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpHealthResponse{");
        sb.append("status=").append(this.status);
        sb.append(", body='").append(this.body).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

