/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.util.Duration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Schedule {
    @JsonProperty
    private @Nullable Duration initialDelay = null;
    @NotNull
    @JsonProperty
    private Duration checkInterval = Duration.seconds((long)5L);
    @NotNull
    @JsonProperty
    private Duration downtimeInterval = Duration.seconds((long)30L);
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int failureAttempts = 3;
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int successAttempts = 2;

    public Duration getInitialDelay() {
        return this.initialDelay == null ? this.getCheckInterval() : this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    public Duration getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(Duration checkInterval) {
        this.checkInterval = checkInterval;
    }

    public Duration getDowntimeInterval() {
        return this.downtimeInterval;
    }

    public void setDowntimeInterval(Duration downtimeInterval) {
        this.downtimeInterval = downtimeInterval;
    }

    public int getFailureAttempts() {
        return this.failureAttempts;
    }

    public void setFailureAttempts(int failureAttempts) {
        this.failureAttempts = failureAttempts;
    }

    public int getSuccessAttempts() {
        return this.successAttempts;
    }

    public void setSuccessAttempts(int successAttempts) {
        this.successAttempts = successAttempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return this.failureAttempts == schedule.failureAttempts && this.successAttempts == schedule.successAttempts && Objects.equals(this.initialDelay, schedule.initialDelay) && Objects.equals(this.checkInterval, schedule.checkInterval) && Objects.equals(this.downtimeInterval, schedule.downtimeInterval);
    }

    public int hashCode() {
        return Objects.hash(this.initialDelay, this.checkInterval, this.downtimeInterval, this.failureAttempts, this.successAttempts);
    }
}

