/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import com.google.common.collect.ImmutableList;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.hibernate.SessionFactoryHealthCheck;
import io.dropwizard.hibernate.UnitOfWorkApplicationListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.SessionFactory;

public abstract class HibernateBundle<T extends Configuration>
implements ConfiguredBundle<T>,
DatabaseConfiguration<T> {
    public static final String DEFAULT_NAME = "hibernate";
    @Nullable
    private SessionFactory sessionFactory;
    private boolean lazyLoadingEnabled = true;
    private final ImmutableList<Class<?>> entities;
    private final SessionFactoryFactory sessionFactoryFactory;

    protected HibernateBundle(Class<?> entity, Class<?> ... entities) {
        this(ImmutableList.builder().add(entity).add((Object[])entities).build(), new SessionFactoryFactory());
    }

    protected HibernateBundle(ImmutableList<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        this.entities = entities;
        this.sessionFactoryFactory = sessionFactoryFactory;
    }

    public final void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)this.createHibernate5Module());
    }

    protected Hibernate5Module createHibernate5Module() {
        Hibernate5Module module = new Hibernate5Module();
        if (this.lazyLoadingEnabled) {
            module.enable(Hibernate5Module.Feature.FORCE_LAZY_LOADING);
        }
        return module;
    }

    protected String name() {
        return DEFAULT_NAME;
    }

    public final void run(T configuration, Environment environment) throws Exception {
        PooledDataSourceFactory dbConfig = this.getDataSourceFactory((Configuration)configuration);
        this.sessionFactory = Objects.requireNonNull(this.sessionFactoryFactory.build((HibernateBundle<?>)this, environment, dbConfig, (List<Class<?>>)this.entities, this.name()));
        this.registerUnitOfWorkListenerIfAbsent(environment).registerSessionFactory(this.name(), this.sessionFactory);
        environment.healthChecks().register(this.name(), (HealthCheck)new SessionFactoryHealthCheck(environment.getHealthCheckExecutorService(), dbConfig.getValidationQueryTimeout().orElse(Duration.seconds((long)5L)), this.sessionFactory, dbConfig.getValidationQuery()));
    }

    private UnitOfWorkApplicationListener registerUnitOfWorkListenerIfAbsent(Environment environment) {
        for (Object singleton : environment.jersey().getResourceConfig().getSingletons()) {
            if (!(singleton instanceof UnitOfWorkApplicationListener)) continue;
            return (UnitOfWorkApplicationListener)singleton;
        }
        UnitOfWorkApplicationListener listener = new UnitOfWorkApplicationListener();
        environment.jersey().register((Object)listener);
        return listener;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public SessionFactory getSessionFactory() {
        return Objects.requireNonNull(this.sessionFactory);
    }

    protected void configure(org.hibernate.cfg.Configuration configuration) {
    }
}

