/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.UnitOfWorkAspect;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.hibernate.SessionFactory;

@Provider
public class UnitOfWorkApplicationListener
implements ApplicationEventListener {
    private ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap = new ConcurrentHashMap<ResourceMethod, Optional<UnitOfWork>>();
    private Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();

    public UnitOfWorkApplicationListener() {
    }

    public UnitOfWorkApplicationListener(String name, SessionFactory sessionFactory) {
        this.registerSessionFactory(name, sessionFactory);
    }

    public void registerSessionFactory(String name, SessionFactory sessionFactory) {
        this.sessionFactories.put(name, sessionFactory);
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent event) {
        return new UnitOfWorkEventListener(this.methodMap, this.sessionFactories);
    }

    private static class UnitOfWorkEventListener
    implements RequestEventListener {
        private ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap;
        private final UnitOfWorkAspect unitOfWorkAspect;

        UnitOfWorkEventListener(ConcurrentMap<ResourceMethod, Optional<UnitOfWork>> methodMap, Map<String, SessionFactory> sessionFactories) {
            this.methodMap = methodMap;
            this.unitOfWorkAspect = new UnitOfWorkAspect(sessionFactories);
        }

        public void onEvent(RequestEvent event) {
            RequestEvent.Type eventType = event.getType();
            if (eventType == RequestEvent.Type.RESOURCE_METHOD_START) {
                Optional unitOfWork = this.methodMap.computeIfAbsent(event.getUriInfo().getMatchedResourceMethod(), UnitOfWorkEventListener::registerUnitOfWorkAnnotations);
                this.unitOfWorkAspect.beforeStart(unitOfWork.orElse(null));
            } else if (eventType == RequestEvent.Type.RESP_FILTERS_START) {
                try {
                    this.unitOfWorkAspect.afterEnd();
                }
                catch (Exception e) {
                    throw new MappableException((Throwable)e);
                }
            } else if (eventType == RequestEvent.Type.ON_EXCEPTION) {
                this.unitOfWorkAspect.onError();
            } else if (eventType == RequestEvent.Type.FINISHED) {
                this.unitOfWorkAspect.onFinish();
            }
        }

        private static Optional<UnitOfWork> registerUnitOfWorkAnnotations(ResourceMethod method) {
            UnitOfWork annotation = method.getInvocable().getDefinitionMethod().getAnnotation(UnitOfWork.class);
            if (annotation == null) {
                annotation = method.getInvocable().getHandlingMethod().getAnnotation(UnitOfWork.class);
            }
            return Optional.ofNullable(annotation);
        }
    }
}

