/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.google.common.base.Preconditions;
import io.dropwizard.hibernate.UnitOfWork;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class UnitOfWorkAspect {
    private final Map<String, SessionFactory> sessionFactories;
    @Nullable
    private UnitOfWork unitOfWork;
    @Nullable
    private Session session;
    @Nullable
    private SessionFactory sessionFactory;

    public UnitOfWorkAspect(Map<String, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public void beforeStart(@Nullable UnitOfWork unitOfWork) {
        if (unitOfWork == null) {
            return;
        }
        this.unitOfWork = unitOfWork;
        this.sessionFactory = this.sessionFactories.get(unitOfWork.value());
        if (this.sessionFactory == null) {
            if (unitOfWork.value().equals("hibernate") && this.sessionFactories.size() == 1) {
                this.sessionFactory = this.sessionFactories.values().iterator().next();
            } else {
                throw new IllegalArgumentException("Unregistered Hibernate bundle: '" + unitOfWork.value() + "'");
            }
        }
        this.session = this.sessionFactory.openSession();
        try {
            this.configureSession();
            ManagedSessionContext.bind((Session)this.session);
            this.beginTransaction(unitOfWork, this.session);
        }
        catch (Throwable th) {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
            throw th;
        }
    }

    public void afterEnd() {
        if (this.unitOfWork == null || this.session == null) {
            return;
        }
        try {
            this.commitTransaction(this.unitOfWork, this.session);
        }
        catch (Exception e) {
            this.rollbackTransaction(this.unitOfWork, this.session);
            throw e;
        }
    }

    public void onError() {
        if (this.unitOfWork == null || this.session == null) {
            return;
        }
        try {
            this.rollbackTransaction(this.unitOfWork, this.session);
        }
        finally {
            this.onFinish();
        }
    }

    public void onFinish() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    protected void configureSession() {
        Preconditions.checkNotNull((Object)this.unitOfWork);
        Preconditions.checkNotNull((Object)this.session);
        this.session.setDefaultReadOnly(this.unitOfWork.readOnly());
        this.session.setCacheMode(this.unitOfWork.cacheMode());
        this.session.setHibernateFlushMode(this.unitOfWork.flushMode());
    }

    private void beginTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        session.beginTransaction();
    }

    private void rollbackTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.rollback();
        }
    }

    private void commitTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.commit();
        }
    }

    protected Session getSession() {
        return Objects.requireNonNull(this.session);
    }

    protected SessionFactory getSessionFactory() {
        return Objects.requireNonNull(this.sessionFactory);
    }
}

