/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.UnitOfWorkAspect;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.SessionFactory;

public class UnitOfWorkAwareProxyFactory {
    private final Map<String, SessionFactory> sessionFactories;

    public UnitOfWorkAwareProxyFactory(String name, SessionFactory sessionFactory) {
        this.sessionFactories = Collections.singletonMap(name, sessionFactory);
    }

    public UnitOfWorkAwareProxyFactory(HibernateBundle<?> ... bundles) {
        HashMap<String, SessionFactory> sessionFactoriesBuilder = new HashMap<String, SessionFactory>();
        for (HibernateBundle<?> bundle : bundles) {
            sessionFactoriesBuilder.put(bundle.name(), bundle.getSessionFactory());
        }
        this.sessionFactories = Collections.unmodifiableMap(sessionFactoriesBuilder);
    }

    public <T> T create(Class<T> clazz) {
        return this.create(clazz, new Class[0], new Object[0]);
    }

    public <T> T create(Class<T> clazz, Class<?> constructorParamType, Object constructorArguments) {
        return this.create(clazz, new Class[]{constructorParamType}, new Object[]{constructorArguments});
    }

    public <T> T create(Class<T> clazz, Class<?>[] constructorParamTypes, Object[] constructorArguments) {
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(clazz);
        try {
            Proxy proxy = (Proxy)(constructorParamTypes.length == 0 ? factory.createClass().getConstructor(new Class[0]).newInstance(new Object[0]) : factory.create((Class[])constructorParamTypes, constructorArguments));
            proxy.setHandler((self, overridden, proceed, args) -> {
                UnitOfWork[] unitsOfWork = (UnitOfWork[])overridden.getAnnotationsByType(UnitOfWork.class);
                HashMap<UnitOfWork, UnitOfWorkAspect> unitOfWorkAspectMap = new HashMap<UnitOfWork, UnitOfWorkAspect>();
                Arrays.stream(unitsOfWork).collect(Collectors.toMap(UnitOfWork::value, Function.identity(), (first, second) -> second)).values().forEach(unitOfWork -> unitOfWorkAspectMap.put((UnitOfWork)unitOfWork, this.newAspect(this.sessionFactories)));
                try {
                    unitOfWorkAspectMap.forEach((unitOfWork, unitOfWorkAspect) -> unitOfWorkAspect.beforeStart((UnitOfWork)unitOfWork));
                    Object result = proceed.invoke(self, args);
                    unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::afterEnd);
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException e) {
                    unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onError);
                    throw e.getCause();
                }
                catch (Exception e) {
                    unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onError);
                    throw e;
                }
                finally {
                    unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onFinish);
                }
            });
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create a proxy for the class '" + clazz + "'", e);
        }
    }

    public UnitOfWorkAspect newAspect() {
        return new UnitOfWorkAspect(this.sessionFactories);
    }

    public UnitOfWorkAspect newAspect(Map<String, SessionFactory> sessionFactories) {
        return new UnitOfWorkAspect(sessionFactories);
    }
}

