/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.DirectExecutorService;
import io.dropwizard.util.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SessionFactoryHealthCheck
extends HealthCheck {
    private final SessionFactory sessionFactory;
    private final Optional<String> validationQuery;
    private final int validationQueryTimeout;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public SessionFactoryHealthCheck(SessionFactory sessionFactory, Optional<String> validationQuery) {
        this((ExecutorService)new DirectExecutorService(), Duration.seconds((long)0L), sessionFactory, validationQuery);
    }

    public SessionFactoryHealthCheck(ExecutorService executorService, Duration duration, SessionFactory sessionFactory, Optional<String> validationQuery) {
        this.sessionFactory = sessionFactory;
        this.validationQuery = validationQuery;
        this.validationQueryTimeout = (int)duration.toSeconds();
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Optional<String> getValidationQuery() {
        return this.validationQuery;
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            HealthCheck.Result result = HealthCheck.Result.healthy();
            try (Session session = this.sessionFactory.openSession();){
                Transaction txn = session.beginTransaction();
                try {
                    if (this.validationQuery.isPresent()) {
                        session.createNativeQuery(this.validationQuery.get()).list();
                    } else if (!this.isValidConnection(session)) {
                        result = HealthCheck.Result.unhealthy((String)"Connection::isValid returned false.");
                    }
                    txn.commit();
                }
                catch (Exception e) {
                    if (txn.getStatus().canRollback()) {
                        txn.rollback();
                    }
                    throw e;
                }
            }
            return result;
        });
    }

    private boolean isValidConnection(Session session) {
        return Boolean.TRUE.equals(session.doReturningWork(connection -> connection.isValid(this.validationQueryTimeout)));
    }
}

