/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.util.Generics;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class AbstractDAO<E> {
    private final SessionFactory sessionFactory;
    private final Class<?> entityClass;

    public AbstractDAO(SessionFactory sessionFactory) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.entityClass = Generics.getTypeParameter(this.getClass());
    }

    protected Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected CriteriaQuery<E> criteriaQuery() {
        return this.currentSession().getCriteriaBuilder().createQuery(this.getEntityClass());
    }

    protected Query<?> namedQuery(String queryName) throws HibernateException {
        return this.currentSession().getNamedQuery(Objects.requireNonNull(queryName));
    }

    protected Query<E> namedTypedQuery(String queryName) throws HibernateException {
        return this.currentSession().createNamedQuery(queryName, this.getEntityClass());
    }

    protected Query<E> query(String queryString) {
        return this.currentSession().createQuery(Objects.requireNonNull(queryString), this.getEntityClass());
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected @Nullable E uniqueResult(CriteriaQuery<E> criteriaQuery) throws HibernateException {
        return (E)AbstractDAO.uniqueElement(this.currentSession().createQuery(Objects.requireNonNull(criteriaQuery)).getResultList());
    }

    private static <T> @Nullable T uniqueElement(List<T> list) throws NonUniqueResultException {
        if (list.isEmpty()) {
            return null;
        }
        Object head = list.get(0);
        if (list.stream().anyMatch(element -> element != head)) {
            throw new NonUniqueResultException(list.size());
        }
        return head;
    }

    protected E uniqueResult(Query<E> query) throws HibernateException {
        return (E)Objects.requireNonNull(query).uniqueResult();
    }

    protected List<E> list(CriteriaQuery<E> criteria) throws HibernateException {
        return this.currentSession().createQuery(Objects.requireNonNull(criteria)).getResultList();
    }

    protected List<E> list(Query<E> query) throws HibernateException {
        return Objects.requireNonNull(query).list();
    }

    protected E get(Object id) {
        return (E)this.currentSession().get(this.entityClass, Objects.requireNonNull(id));
    }

    protected E persist(E entity) throws HibernateException {
        this.currentSession().saveOrUpdate(Objects.requireNonNull(entity));
        return entity;
    }

    protected <T> T initialize(T proxy) throws HibernateException {
        if (!Hibernate.isInitialized(proxy)) {
            Hibernate.initialize(proxy);
        }
        return proxy;
    }
}

